
// Test agent

/* 
   Beliefs
*/

auction_id(0).

/*
   Initial goal
*/
!all_tests.



/*
   Test plans
*/

// Plan performing all tests
+!all_tests
  <- .wait(1000);
     !!test_construct_allocation;
  	 .wait(1000);
     !!test_set_welfare;
  	 .wait(1000);
     !!test_set_timeout;
  	 .wait(1000);
     !!test_set_personal_weights;
  	 .wait(1000);
     !!test_set_utility_weights;
  	 .wait(1000);
     !!test_launch_decision;
  	 .wait(1000);
     !!test_launch_specific_decision.

// Test for jmadem.construct_allocation()
+!test_construct_allocation 
  <- .println("Initiating test for jmadem.construct_allocation()");
     //jmadem.construct_allocations(use(CoffeeMachine, age), [age], [[fernando,miguel,fran]], ResultAllocations);
	 //jmadem.construct_allocations(use(machine, age), [machine, age], [[coffeeMachine, juiceMachine],[fernando,miguel,fran]], ResultAllocations);
	 //jmadem.construct_allocations(use(machine, product, age, when), [machine, age, when], [[coffeeMachine, juiceMachine],[fernando,miguel,fran],[now, [tomorrow, midday]]], ResultAllocations);
     Task = use(CoffeeMachine, age);
	 Slots = [age];
	 Elements = [[fernando,miguel,fran]];
     jmadem.construct_allocations(Task, Slots, Elements, ResultAllocations);
     .println("Result allocation: ", ResultAllocations);
	 .println("Succesful test for jmadem.construct_allocation()").
-!test_construct_allocation 
  <- .println("Failed test for jmadem.construct_allocation()").

// Test for jmadem.set_welfare() 
+!test_set_welfare 
  <- .println("Initiating test for jmadem.set_welfare()");
     jmadem.set_welfare(utilitarian);
	 jmadem.set_welfare(egalitarian);
	 jmadem.set_welfare(elitist);
	 jmadem.set_welfare(nash);
	 Welfare = utilitarian;
     jmadem.set_welfare(Welfare); 
	 jmadem.get_welfare(W);
	 .println("Welfare set to: ", W);
	 .println("Succesful test for jmadem.set_welfare()").
-!test_set_welfare 
  <- .println("Failed test for jmadem.set_welfare()").

// Test for jmadem.set_timeout() 
+!test_set_timeout 
  <- .println("Initiating test for jmadem.set_timeout()");
     jmadem.set_timeout(500); 
     jmadem.set_timeout(1.5); 
     jmadem.set_timeout(2000); 
	 Timeout = 1000;
     jmadem.set_timeout(Timeout); 
	 jmadem.get_timeout(T);
	 .println("Timeout set to: ", T);
	 .println("Succesful test for jmadem.set_timeout()").
-!test_set_timeout 
  <- .println("Failed test for jmadem.set_timeout()").

// Test for jmadem.set_personal_weights() 
+!test_set_personal_weights 
  <- .println("Initiating test for jmadem.set_personal_weights()");
     //jmadem.set_personal_weights([[fernando,0.25],[miguel,0.5],[fran,0.25]]); 
	 ListOfPairs = [[fernando,0.25],[miguel,0.5],[fran,0.25]];
     jmadem.set_personal_weights(ListOfPairs); 
	 jmadem.get_personal_weights(L);
	 .println("Personal weights set to: ", L);
	 .println("Succesful test for jmadem.set_personal_weights()").
-!test_set_personal_weights 
  <- .println("Failed test for jmadem.set_personal_weights()").

// Test for jmadem.set_utility_weights() 
+!test_set_utility_weights 
  <- .println("Initiating test for jmadem.set_utility_weights()");
     //jmadem.set_utility_weights([[minimumUtilityFunction,0.25],[maximumUtilityFunction,0.75]]); 
	 ListOfPairs = [[minimumUtilityFunction,0.25],[maximumUtilityFunction,0.75]];
     jmadem.set_utility_weights(ListOfPairs); 
	 jmadem.get_utility_weights(L);
	 .println("Utility weights set to: ", L);
	 .println("Succesful test for jmadem.set_utility_weights()").
-!test_set_utility_weights 
  <- .println("Failed test for jmadem.set_utility_weights()").

// Test for jmadem.launch_decision() 
+!test_launch_decision 
  <- .println("Initiating test for jmadem.launch_decision()");
  	 jmadem.add_utility_function("testAgent.MinimumUtilityFunction");
  	 jmadem.add_utility_function("testAgent.MaximumUtilityFunction");
	 jmadem.get_utility_function_names(UFNames);
	 .println("Registered utility functions: ", UFNames);
     jmadem.set_personal_weights([[fernando,0.25],[miguel,0.5],[fran,0.75],[testAgent,0.5]]); 
	 UtilityWeights = [[minimumUtilityFunction,0.25],[maximumUtilityFunction,0.75]];
     jmadem.set_utility_weights(UtilityWeights); 
     Task = use(CoffeeMachine, age);
	 Slots = [age];
	 Elements = [[testAgent,fernando,miguel,fran]];
     jmadem.construct_allocations(Task, Slots, Elements, ResultAllocations);
 	 jmadem.set_welfare(elitist);
     jmadem.launch_decision([testAgent,fernando,miguel,fran], ResultAllocations, [maximumUtilityFunction,minimumUtilityFunction], DecisionId);
     //jmadem.launch_decision([testAgent,fernando,miguel,fran], ResultAllocations, [maximumUtilityFunction,minimumUtilityFunction]);
	 //AgentNames = [testAgent, fran, miguel, fernando];
	 //UtilityNames = [maximumUtilityFunction,minimumUtilityFunction];
     //jmadem.launch_decision(AgentNames, ResultAllocations, UtilityNames, DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_launch_decision 
  <- .println("Failed test for jmadem.launch_decision()").
+madem_result(DecisionId, Allocation)
  <- .println("MADeM Result for DecisionId ", DecisionId, " is ", Allocation);
	 .println("Succesful test for jmadem.launch_decision()").

// Test for jmadem.launch_specific_decision() 
+!test_launch_specific_decision 
  <- .println("Initiating test for jmadem.launch_specific_decision()");
     Task = use(CoffeeMachine, age);
	 Slots = [age];
	 Elements = [[fran,fernando,miguel]];
     jmadem.construct_allocations(Task, Slots, Elements, ResultAllocations);
     jmadem.launch_specific_decision([fran, miguel, fernando], ResultAllocations, 
	 						  		 [maximumUtilityFunction,minimumUtilityFunction],
									 [[fernando,0.25],[miguel,0.5],[fran,0.75]],
									 [[minimumUtilityFunction,1],[maximumUtilityFunction,0.25]],
									 egalitarian, 1000, DecisionId);
	 AgentNames = [fran, miguel, fernando];
	 UtilityNames = [maximumUtilityFunction,minimumUtilityFunction];
	 PersonalWeights = [[fernando,0.25],[miguel,0.5],[fran,0.75]];
	 UtilityWeights = [[minimumUtilityFunction,1],[maximumUtilityFunction,0.25]];
	 Welfare = egalitarian;
	 Timeout = 1000;
     //jmadem.launch_specific_decision(AgentNames, ResultAllocations, UtilityNames, PersonalWeights, UtilityWeights, Welfare, Timeout, DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_launch_specific_decision 
  <- .println("Failed test for jmadem.launch_specific_decision()").

