// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://grev.uv.es
// http://www.uv.es/agentes
//
//----------------------------------------------------------------------------

package jmadem;

/** 
 * Interface for the utility functions invoked by MADeMAgArch agents.
 * The code of every utility function must implement this interface.
 *
 * @author Francisco Grimaldo
 */
public interface UtilityFunctionInt 
{
	/**
	  * Returns the name of the utility function
	  * <p>
	  * <b>IMPORTANT NOTE: </b> All utility function names must start in lowercase due
	  * to Jason's interpretation of uppercase as variable terms when launching MADeM.
	  * </p>
	  *
	  * @return	name of the utility function
	  */
    public String getId();

	/**
	  * Computes the normalized utility value given to an allocation. 
	  *
	  * @param	auctioneer	agent asking for preference
	  * @param	alloc	allocation being evaluated
	  * @param	agArch	architecture of the MADeM agent
	  * 
	  * @throws	UtilityFunctionException when any error occurs
	  * @return	the utility value assigned to the allocation. Utility values are
	  *         between [0, 1]; 0 meaning no preference and 1 meaning the highest preference 
	  */
    public float computeUtility(String auctioneer, Allocation alloc, MADeMAgArch agArch) throws UtilityFunctionException;
}
