// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://grev.uv.es
// http://www.uv.es/agentes
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.StringTermImpl;

import java.util.logging.Logger;

/** 
 * Internal function for adding an utility function to the MADeM agent.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.add_utility_function("package.UtilityFunctionName")</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class add_utility_function extends DefaultInternalAction  {

	private static final long serialVersionUID = 460589402971649349L;
	
	Logger logger = Logger.getLogger(add_utility_function.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		try
		{
			// Get the name of the utility function from the arguments
			Term uFuncTerm = args[0];
			if (uFuncTerm instanceof VarTerm)
				uFuncTerm = ((VarTerm) uFuncTerm).getValue();
			String uFuncClass = ((StringTermImpl) uFuncTerm).getString();
					
			// Register the new utility function
			MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
			if (agArch.addUtilityFunction(uFuncClass))
				logger.fine("Utility function " + uFuncClass + " correctly added.");
			else
			{
				logger.severe("Error adding utility function "+ args[0]);
				return false;
			}
		}
		catch (Exception e)
		{
			logger.severe("Error adding utility function "+ args[0]);
			e.printStackTrace();
    	    return false;
		}
		return true;
    }
}
