// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://grev.uv.es
// http://www.uv.es/agentes
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.NumberTermImpl;

import java.util.logging.Logger;

/** 
 * Internal function for changing bid timeout in the MADeM agent. 
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.set_timeout(Timeout)</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class set_timeout extends DefaultInternalAction  {

	private static final long serialVersionUID = 3668597922430484758L;
	
	Logger logger = Logger.getLogger(set_timeout.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		// Get the new timeout value from the arguments
		int tout = 0;
		try
		{
			Term toutTerm = args[0];
			if (toutTerm instanceof VarTerm)
				toutTerm = ((VarTerm) toutTerm).getValue();
			tout = (int) ((NumberTermImpl) toutTerm).solve();
		}
		catch (Exception e)
		{
			logger.severe("Error reading parameters while changing timeout.");
			e.printStackTrace();
			return false;
		}

		// Set the new timeout
		MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
		if (agArch.setTimeout(tout))
			logger.fine("Timeout correctly changed to " + tout + "ms.");
    	else
		{
    		logger.severe("Error changing Timeout to "+ tout +" ms.");
    	    return false;
		}
		return true;
    }
}
