// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://grev.uv.es
// http://www.uv.es/agentes
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Atom;

import java.util.logging.Logger;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.List;

/** 
 * Internal function for changing the utility weights of the MADeM agent.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.set_utility_weights([ [UtilityName, Weight] | ListOfPairs ])</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class set_utility_weights extends DefaultInternalAction  {

	private static final long serialVersionUID = -4251770750670387879L;
	
	Logger logger = Logger.getLogger(set_utility_weights.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		// Read the list of pairs with the new utility weights
		ConcurrentMap<Atom, Float> utilityWeights = new ConcurrentHashMap<Atom, Float>();
		try
		{
			Term uwPairsTerm = args[0];
			if (uwPairsTerm instanceof VarTerm)
				uwPairsTerm = ((VarTerm) uwPairsTerm).getValue();
			Iterator<Term> it = ((ListTermImpl) uwPairsTerm).iterator();
			while (it.hasNext())
			{
				List<Term> pair = ((ListTermImpl) it.next()).getAsList();
				utilityWeights.put( (Atom) (pair.get(0)), 
								   new Float(((NumberTermImpl) pair.get(1)).solve()) );
			}
		}
		catch (Exception e)
		{
			logger.severe("Error changing utility weights to " + args[0]);
			e.printStackTrace();
			return false;
		}
		
		// Set the new utility weights
		MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
		if ( agArch.setUtilityWeights(utilityWeights) )
			logger.fine("Utility weights correctly changed to " + utilityWeights);
		else
			return false;
		
		return true;
    }
}
