/*
 * Decompiled with CFR 0.152.
 */
package jmadem;

import jason.NoValueException;
import jason.asSyntax.Atom;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;
import jmadem.Cuf;
import jmadem.Multimodality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionData {
    private Logger logger = Logger.getLogger(DecisionData.class.getName());
    private static int id_generator = 1;
    private int id;
    private List<Atom> agents;
    private List<Term> allocations;
    private List<Atom> utilityFunctions;
    private Map<Atom, Float> utilityWeights;
    private Map<Atom, Float> personalWeights;
    private Cuf welfare;
    private Multimodality multimodality;
    private ConcurrentMap<Atom, List<Float>> utilityValues;
    private boolean decisionClosed;
    private boolean multipleSolution;
    private boolean returnWelfare;
    private ScheduledFuture<?> timeoutTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DecisionData(List<Atom> ags, List<Term> allocs, List<Atom> uFuncs, ConcurrentMap<Atom, Float> pW, ConcurrentMap<Atom, Float> uW, Cuf sw, Multimodality m, boolean multipleSolutions, boolean returnWelfare) {
        Class<DecisionData> clazz = DecisionData.class;
        synchronized (DecisionData.class) {
            this.id = id_generator;
            id_generator = id_generator == Integer.MAX_VALUE ? 1 : ++id_generator;
            // ** MonitorExit[var10_10] (shouldn't be in output)
            this.logger = Logger.getLogger(DecisionData.class.getName());
            this.agents = ags;
            this.allocations = allocs;
            this.utilityFunctions = uFuncs;
            this.personalWeights = new HashMap<Atom, Float>((int)((double)pW.size() * 0.75) + 1);
            this.personalWeights.putAll(pW);
            this.utilityWeights = new HashMap<Atom, Float>((int)((double)uW.size() * 0.75) + 1);
            this.utilityWeights.putAll(uW);
            this.welfare = sw;
            this.multimodality = m;
            this.utilityValues = new ConcurrentHashMap<Atom, List<Float>>((int)((double)ags.size() * 0.75) + 1);
            this.decisionClosed = false;
            this.multipleSolution = multipleSolutions;
            this.returnWelfare = returnWelfare;
            return;
        }
    }

    public void setTimeoutTask(ScheduledFuture<?> timeoutTask) {
        this.timeoutTask = timeoutTask;
    }

    public ScheduledFuture<?> getTimeoutTask() {
        return this.timeoutTask;
    }

    public int getId() {
        return this.id;
    }

    public boolean isDecisionClosed() {
        return this.decisionClosed;
    }

    public void setDecisionClosed(boolean decisionClosed) {
        this.decisionClosed = decisionClosed;
    }

    public void setMultipleSolution(boolean multipleSolution) {
        this.multipleSolution = multipleSolution;
    }

    public boolean isMultipleSolution() {
        return this.multipleSolution;
    }

    public void setReturnWelfare(boolean returnWelfare) {
        this.returnWelfare = returnWelfare;
    }

    public boolean getReturnWelfare() {
        return this.returnWelfare;
    }

    public void addBid(String bidder, List<Term> uValues) {
        Vector<Float> uV = new Vector<Float>((int)((double)uValues.size() * 0.75) + 1);
        for (Term t : uValues) {
            if (t.isNumeric()) {
                try {
                    uV.add(new Float(((NumberTerm)t).solve()));
                }
                catch (NoValueException e) {
                    uV.add(null);
                    this.logger.severe("Utility value \"" + t + "\" is not numeric while adding a bid.");
                    e.printStackTrace();
                }
                continue;
            }
            uV.add(null);
        }
        this.utilityValues.put(new Atom(bidder), uV);
    }

    public boolean areAllBidsReceived() {
        return this.agents.size() == this.utilityValues.size();
    }

    public List<Atom> getAgents() {
        return this.agents;
    }

    public Map<Atom, Float> getPersonalWeights() {
        return this.personalWeights;
    }

    public List<Term> getAllocations() {
        return this.allocations;
    }

    public List<Atom> getUtilityFunctions() {
        return this.utilityFunctions;
    }

    public Map<Atom, Float> getUtilityWeights() {
        return this.utilityWeights;
    }

    public Cuf getWelfare() {
        return this.welfare;
    }

    public ConcurrentMap<Atom, List<Float>> getUtilityValues() {
        return this.utilityValues;
    }

    public void setMultimodality(Multimodality new_multimodality) {
        this.multimodality = new_multimodality;
    }

    public Multimodality getMultimodality() {
        return this.multimodality;
    }
}

