/*
 * Decompiled with CFR 0.152.
 */
package jmadem;

import jason.NoValueException;
import jason.architecture.AgArch;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.Message;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.VarTerm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jmadem.Cuf;
import jmadem.DecisionData;
import jmadem.FilterFunctionInt;
import jmadem.Multimodality;
import jmadem.UtilityFunctionException;
import jmadem.UtilityFunctionInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MADeMAgArch
extends AgArch {
    private Logger logger = Logger.getLogger(MADeMAgArch.class.getName());
    private Random random = new Random();
    private ConcurrentMap<Atom, FilterFunctionInt> filterFunctions = new ConcurrentHashMap<Atom, FilterFunctionInt>();
    private ConcurrentMap<Atom, UtilityFunctionInt> utilityFunctions = new ConcurrentHashMap<Atom, UtilityFunctionInt>();
    private ConcurrentMap<Atom, Float> utilityWeights = new ConcurrentHashMap<Atom, Float>();
    private ConcurrentMap<Atom, Float> personalWeights = new ConcurrentHashMap<Atom, Float>();
    private Cuf welfare;
    private Multimodality multimodality;
    private int tout = 5000;
    private ScheduledExecutorService timeoutScheduler;
    private ConcurrentMap<Integer, DecisionData> mademData = new ConcurrentHashMap<Integer, DecisionData>();
    private boolean automaticRemoveOfMademData = true;
    private ConcurrentMap<ListTerm, List<Term>> utilityValues = new ConcurrentHashMap<ListTerm, List<Term>>();

    public MADeMAgArch() {
        this.logger = Logger.getLogger(String.valueOf(MADeMAgArch.class.getName()) + "." + this.getAgName());
        this.welfare = Cuf.ELITIST;
        this.multimodality = Multimodality.COMPETITIVE;
        this.timeoutScheduler = Executors.newScheduledThreadPool(5);
    }

    public void setAutomaticRemoveOfMademData(boolean automaticRemoveOfMademData) {
        this.automaticRemoveOfMademData = automaticRemoveOfMademData;
    }

    public boolean isAutomaticRemoveOfMademData() {
        return this.automaticRemoveOfMademData;
    }

    public boolean addFilterFunction(Atom fFuncName, String fFuncClass) {
        FilterFunctionInt f = null;
        try {
            f = (FilterFunctionInt)Class.forName(fFuncClass).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (this.filterFunctions.put(fFuncName, f) != null) {
            this.logger.fine("Filter function \"" + fFuncName + "\" has been updated.");
        } else {
            this.logger.fine("Filter function \"" + fFuncName + "\" has been registered.");
        }
        return true;
    }

    public boolean removeFilterFunction(Atom fFuncName) {
        return this.filterFunctions.remove(fFuncName) == null;
    }

    public Set<Atom> getFilterFunctionNames() {
        return this.filterFunctions.keySet();
    }

    public boolean doFilter(Term allocation, ListTerm fFuncs) {
        boolean valid = true;
        Iterator it_fFuncs = fFuncs.iterator();
        while (valid && it_fFuncs.hasNext()) {
            Atom fFuncName = (Atom)it_fFuncs.next();
            FilterFunctionInt filterFunction = (FilterFunctionInt)this.filterFunctions.get(fFuncName);
            try {
                this.logger.fine("Invoking the filter function named " + fFuncName);
                valid = !filterFunction.doFilter(allocation, this);
            }
            catch (Exception e) {
                this.logger.warning("Error invoking the filter function named " + fFuncName + ", it seems not to be registered");
                valid = false;
            }
        }
        return valid;
    }

    public boolean addUtilityFunction(Atom uFuncName, String uFuncClass) {
        UtilityFunctionInt u = null;
        try {
            u = (UtilityFunctionInt)Class.forName(uFuncClass).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (this.utilityFunctions.put(uFuncName, u) != null) {
            this.logger.fine("Utility function \"" + uFuncName + "\" has been updated.");
        } else {
            this.logger.fine("Utility function \"" + uFuncName + "\" has been registered.");
        }
        return true;
    }

    public boolean removeUtilityFunction(Atom uFuncName) {
        return this.utilityFunctions.remove(uFuncName) == null;
    }

    public Set<Atom> getUtilityFunctionNames() {
        return this.utilityFunctions.keySet();
    }

    public int startMADeMDecision(ListTerm ags, ListTerm allocs, ListTerm uFuncs, boolean multipleSolutions, boolean returnWelfare) {
        return this.startMADeMDecision(ags, allocs, uFuncs, this.personalWeights, this.utilityWeights, this.welfare, this.multimodality, this.tout, multipleSolutions, returnWelfare);
    }

    public int startMADeMDecision(ListTerm ags, ListTerm allocs, ListTerm uFuncs, ConcurrentMap<Atom, Float> pW, ConcurrentMap<Atom, Float> uW, Cuf sw, Multimodality m, int tout, boolean multipleSolutions, boolean returnWelfare) {
        List<Atom> v_ags = Arrays.asList(new Atom[ags.size()]);
        int i = 0;
        for (Term ag : ags.getAsList()) {
            v_ags.set(i, (Atom)ag);
            ++i;
        }
        List v_allocs = allocs.getAsList();
        List<Atom> v_uFuncs = Arrays.asList(new Atom[uFuncs.size()]);
        i = 0;
        for (Term uf : uFuncs.getAsList()) {
            v_uFuncs.set(i, (Atom)uf);
            ++i;
        }
        DecisionData decision = new DecisionData(v_ags, v_allocs, v_uFuncs, pW, uW, sw, m, multipleSolutions, returnWelfare);
        this.mademData.put(new Integer(decision.getId()), decision);
        Literal auction = ASSyntax.createLiteral((String)"jmadem_auction", (Term[])new Term[0]);
        auction.addTerm((Term)new NumberTermImpl((double)decision.getId()));
        auction.addTerm((Term)allocs);
        auction.addTerm((Term)uFuncs);
        this.logger.fine("Auction message: " + auction);
        String agName = this.getAgName();
        Message msg = new Message("tell", agName, agName, (Object)auction);
        i = 0;
        while (i < v_ags.size()) {
            if (v_ags.get(i).toString().equals(agName)) {
                this.logger.fine("Obtaining personal preferences for " + auction);
                this.computeUtilities(agName, auction);
            } else {
                msg.setReceiver(v_ags.get(i).toString());
                try {
                    this.sendMsg(msg);
                }
                catch (Exception e) {
                    this.logger.severe("Error sending message \"" + msg + "\" while starting MADeM.");
                    e.printStackTrace();
                    this.mademData.remove(new Integer(decision.getId()));
                    return -1;
                }
                this.logger.fine("Auctioned message sent to " + v_ags.get(i));
            }
            ++i;
        }
        if (v_ags.size() != 0) {
            decision.setTimeoutTask(this.timeoutScheduler.schedule(new BidTimeout(decision.getId()), (long)tout, TimeUnit.MILLISECONDS));
        } else {
            this.winnerDeterminationProblem(decision.getId(), false);
        }
        return decision.getId();
    }

    public void checkMail() {
        super.checkMail();
        Iterator i = this.getTS().getC().getMailBox().iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            Object body = m.getPropCont();
            if (body instanceof Literal && ((Literal)body).getFunctor().equals("jmadem_auction")) {
                i.remove();
                this.computeUtilities(m.getSender(), (Literal)body);
            }
            if (!(body instanceof Literal) || !((Literal)body).getFunctor().equals("jmadem_bid")) continue;
            i.remove();
            this.processBid(m.getSender(), (Literal)body);
        }
    }

    public boolean setTimeout(int new_tout) {
        if (new_tout > 0) {
            this.tout = new_tout;
            return true;
        }
        return false;
    }

    public int getTimeout() {
        return this.tout;
    }

    public void setWelfare(Cuf new_sw) {
        this.welfare = new_sw;
    }

    public String getWelfare() {
        return this.welfare.name();
    }

    public void setMultimodality(Multimodality new_multimodality) {
        this.multimodality = new_multimodality;
    }

    public String getMultimodality() {
        return this.multimodality.name();
    }

    public boolean setPersonalWeight(Atom agName, Float new_pw) {
        this.personalWeights.put(agName, new_pw);
        return true;
    }

    public float getPersonalWeight(Atom agName) {
        Float weight = (Float)this.personalWeights.get(agName);
        if (weight != null) {
            return weight.floatValue();
        }
        return 1.0f;
    }

    public boolean setPersonalWeights(ConcurrentMap<Atom, Float> new_pw) {
        this.personalWeights.putAll(new_pw);
        return true;
    }

    public ConcurrentMap<Atom, Float> getPersonalWeights() {
        return this.personalWeights;
    }

    public float getUtilityWeight(Atom utilityName) {
        Float weight = (Float)this.utilityWeights.get(utilityName);
        if (weight != null) {
            return weight.floatValue();
        }
        return 1.0f;
    }

    public boolean setUtilityWeight(Atom utilityName, Float new_uw) {
        this.utilityWeights.put(utilityName, new_uw);
        return true;
    }

    public boolean setUtilityWeights(ConcurrentMap<Atom, Float> new_uw) {
        this.utilityWeights.putAll(new_uw);
        return true;
    }

    public ConcurrentMap<Atom, Float> getUtilityWeights() {
        return this.utilityWeights;
    }

    private void computeUtilities(String auctioneer, Literal madem_auction) {
        List allocs = ((ListTerm)madem_auction.getTerm(1)).getAsList();
        ListTerm uFuncs = (ListTerm)madem_auction.getTerm(2);
        ListTermImpl utilityKey = new ListTermImpl();
        utilityKey.add((Object)ASSyntax.createAtom((String)auctioneer));
        utilityKey.add((Object)madem_auction.getTerm(0));
        List<Term> uValues = Arrays.asList(new Term[allocs.size() * uFuncs.size()]);
        this.utilityValues.put((ListTerm)utilityKey, uValues);
        float utilityValue = 0.0f;
        int utilityId = 0;
        int nAlloc = 0;
        while (nAlloc < allocs.size()) {
            Term alloc = (Term)allocs.get(nAlloc);
            for (Term t : uFuncs) {
                Atom uFuncName = (Atom)t;
                UtilityFunctionInt utilityFunction = (UtilityFunctionInt)this.utilityFunctions.get(uFuncName);
                if (utilityFunction != null) {
                    this.logger.fine("Compute utility by invoking the utility function named " + uFuncName);
                    utilityValue = this.getUtility(auctioneer, alloc, utilityFunction);
                    uValues.set(utilityId, (Term)ASSyntax.createNumber((double)utilityValue));
                } else {
                    this.logger.fine("Add compute utility event for the utility function named " + uFuncName);
                    Literal ufEvent = ASSyntax.createLiteral((String)"jmadem_utility", (Term[])new Term[]{uFuncName, ASSyntax.createAtom((String)auctioneer), alloc, new VarTerm("Utility")});
                    ListTermImpl computeUtilityId = new ListTermImpl();
                    computeUtilityId.addAll((Collection)utilityKey);
                    computeUtilityId.add((Object)ASSyntax.createNumber((double)utilityId));
                    Literal jmademUtility = ASSyntax.createLiteral((String)"jmadem_compute_utility", (Term[])new Term[]{computeUtilityId, ufEvent});
                    this.getTS().updateEvents(new Event(new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, jmademUtility), Intention.EmptyInt));
                }
                ++utilityId;
            }
            ++nAlloc;
        }
        if (!uValues.contains(null)) {
            this.bid((ListTerm)utilityKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void catchUtilityValue(ListTerm utilityKey, Term utilityValue) {
        int id;
        Term utilityIdTerm = utilityKey.removeLast();
        try {
            id = (int)((NumberTerm)utilityIdTerm).solve();
        }
        catch (NoValueException e) {
            id = -1;
            this.logger.severe("Utility Id \"" + utilityIdTerm + "\" is not numeric while catching utility value.");
            e.printStackTrace();
        }
        List uValues = (List)this.utilityValues.get(utilityKey);
        if (uValues == null || id == -1) {
            return;
        }
        List list = uValues;
        synchronized (list) {
            uValues.set(id, utilityValue);
            if (!uValues.contains(null)) {
                this.bid(utilityKey);
            }
        }
    }

    private void bid(ListTerm utilityKey) {
        double mademAuctionId;
        List uValues = (List)this.utilityValues.remove(utilityKey);
        String auctioneer = ((Term)utilityKey.get(0)).toString();
        try {
            mademAuctionId = ((NumberTerm)utilityKey.get(1)).solve();
        }
        catch (NoValueException e1) {
            this.logger.severe("MADeM auction Id \"" + utilityKey.get(1) + "\" is not numeric while bidding.");
            e1.printStackTrace();
            return;
        }
        Literal bidResult = ASSyntax.createLiteral((String)"jmadem_bid", (Term[])new Term[0]);
        bidResult.addTerm((Term)ASSyntax.createNumber((double)mademAuctionId));
        bidResult.addTerm((Term)ASSyntax.createList((Collection)uValues));
        String agName = this.getAgName();
        if (agName.equals(auctioneer)) {
            this.processBid(agName, bidResult);
        } else {
            Message msg = new Message("tell", agName, auctioneer, (Object)bidResult);
            try {
                this.sendMsg(msg);
            }
            catch (Exception e) {
                this.logger.severe("Error sending message \"" + msg + "\" while bidding.");
                e.printStackTrace();
            }
        }
    }

    private void processBid(String bidder, Literal madem_bid) {
        int id_decision = (int)((NumberTermImpl)madem_bid.getTerm(0)).solve();
        DecisionData decisionData = (DecisionData)this.mademData.get(new Integer(id_decision));
        if (decisionData != null && !decisionData.isDecisionClosed()) {
            decisionData.addBid(bidder, ((ListTermImpl)madem_bid.getTerm(1)).getAsList());
            if (decisionData.areAllBidsReceived()) {
                this.winnerDeterminationProblem(id_decision, false);
            }
        }
    }

    private float getUtility(String auctioneer, Term allocation, UtilityFunctionInt utilityFunction) {
        float utility = 0.0f;
        try {
            utility = utilityFunction.computeUtility(auctioneer, allocation, this);
        }
        catch (UtilityFunctionException e) {
            this.logger.warning("Error computing utility function for the allocation \"" + allocation + "\".");
            e.printStackTrace();
        }
        return utility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void winnerDeterminationProblem(int id_decision, boolean timeout) {
        Object winnersPerUFuncWelfare;
        Float utilityValue;
        int k;
        Float socialWelfare;
        int j;
        int i;
        Float w;
        DecisionData decision = null;
        decision = this.automaticRemoveOfMademData ? (DecisionData)this.mademData.remove(id_decision) : (DecisionData)this.mademData.get(id_decision);
        if (decision == null) {
            return;
        }
        DecisionData decisionData = decision;
        synchronized (decisionData) {
            decision.getTimeoutTask().cancel(false);
            if (decision.isDecisionClosed()) {
                return;
            }
            decision.setDecisionClosed(true);
        }
        this.logger.fine("Starting Winner Determination Problem.");
        List<Atom> agents = decision.getAgents();
        Map<Atom, Float> personalWeights = decision.getPersonalWeights();
        List<Term> allocs = decision.getAllocations();
        List<Atom> uFuncs = decision.getUtilityFunctions();
        Map<Atom, Float> utilityWeights = decision.getUtilityWeights();
        ConcurrentMap<Atom, List<Float>> utilityValues = decision.getUtilityValues();
        Cuf welfare = decision.getWelfare();
        this.logger.fine("Agents: " + agents);
        this.logger.fine("Personal Weights: " + personalWeights);
        this.logger.fine("Allocations: " + allocs);
        this.logger.fine("Utility Functions: " + uFuncs);
        this.logger.fine("Utility Weights: " + utilityWeights);
        this.logger.fine("Welfare: " + (Object)((Object)welfare));
        this.logger.fine("Utility Values (agent = [Allocations X UtilityFunctions]):\n" + utilityValues);
        for (Map.Entry element : utilityValues.entrySet()) {
            List uValues = (List)element.getValue();
            w = personalWeights.get(element.getKey());
            if (w == null) continue;
            i = 0;
            while (i < uValues.size()) {
                if (uValues.get(i) != null) {
                    uValues.set(i, Float.valueOf(w.floatValue() * ((Float)uValues.get(i)).floatValue()));
                }
                ++i;
            }
        }
        this.logger.fine("Weighted Utility Values (agent = [Allocations X UtilityFunctions*PersonalWeights]):\n" + utilityValues);
        HashSet<Integer> mademWinners = new HashSet<Integer>();
        Float mademWinnersWelfare = null;
        List agentBids = null;
        if (decision.getMultimodality() == Multimodality.AGGREGATE) {
            j = 0;
            while (j < allocs.size()) {
                Float aggregatedWelfare = null;
                i = 0;
                while (i < uFuncs.size()) {
                    socialWelfare = null;
                    k = 0;
                    while (k < agents.size()) {
                        agentBids = (List)utilityValues.get(agents.get(k));
                        if (agentBids != null && (utilityValue = (Float)agentBids.get(j * uFuncs.size() + i)) != null) {
                            if (socialWelfare == null) {
                                socialWelfare = utilityValue;
                            } else {
                                switch (welfare) {
                                    case UTILITARIAN: {
                                        socialWelfare = Float.valueOf(socialWelfare.floatValue() + utilityValue.floatValue());
                                        break;
                                    }
                                    case EGALITARIAN: {
                                        if (!(socialWelfare.floatValue() > utilityValue.floatValue())) break;
                                        socialWelfare = utilityValue;
                                        break;
                                    }
                                    case ELITIST: {
                                        if (!(socialWelfare.floatValue() < utilityValue.floatValue())) break;
                                        socialWelfare = utilityValue;
                                        break;
                                    }
                                    case NASH: {
                                        socialWelfare = Float.valueOf(socialWelfare.floatValue() * utilityValue.floatValue());
                                        break;
                                    }
                                }
                            }
                        }
                        ++k;
                    }
                    if (socialWelfare != null) {
                        w = utilityWeights.get(uFuncs.get(i));
                        if (w == null) {
                            w = new Float(1.0f);
                        }
                        aggregatedWelfare = aggregatedWelfare == null ? Float.valueOf(w.floatValue() * socialWelfare.floatValue()) : Float.valueOf(aggregatedWelfare.floatValue() + w.floatValue() * socialWelfare.floatValue());
                    }
                    ++i;
                }
                if (aggregatedWelfare != null) {
                    if (mademWinnersWelfare == null) {
                        mademWinnersWelfare = aggregatedWelfare;
                        mademWinners.add(j);
                    } else if (aggregatedWelfare.equals(mademWinnersWelfare)) {
                        mademWinners.add(j);
                    } else if (aggregatedWelfare.floatValue() > mademWinnersWelfare.floatValue()) {
                        mademWinnersWelfare = aggregatedWelfare;
                        mademWinners.clear();
                        mademWinners.add(j);
                    }
                }
                ++j;
            }
        } else {
            ArrayList winnersPerUFunc = new ArrayList((int)((double)uFuncs.size() * 0.75) + 1);
            winnersPerUFuncWelfare = Arrays.asList(new Float[uFuncs.size()]);
            i = 0;
            while (i < uFuncs.size()) {
                winnersPerUFunc.add(new ArrayList());
                j = 0;
                while (j < allocs.size()) {
                    socialWelfare = null;
                    k = 0;
                    while (k < agents.size()) {
                        agentBids = (List)utilityValues.get(agents.get(k));
                        if (agentBids != null && (utilityValue = (Float)agentBids.get(j * uFuncs.size() + i)) != null) {
                            if (socialWelfare == null) {
                                socialWelfare = utilityValue;
                            } else {
                                switch (welfare) {
                                    case UTILITARIAN: {
                                        socialWelfare = Float.valueOf(socialWelfare.floatValue() + utilityValue.floatValue());
                                        break;
                                    }
                                    case EGALITARIAN: {
                                        if (!(socialWelfare.floatValue() > utilityValue.floatValue())) break;
                                        socialWelfare = utilityValue;
                                        break;
                                    }
                                    case ELITIST: {
                                        if (!(socialWelfare.floatValue() < utilityValue.floatValue())) break;
                                        socialWelfare = utilityValue;
                                        break;
                                    }
                                    case NASH: {
                                        socialWelfare = Float.valueOf(socialWelfare.floatValue() * utilityValue.floatValue());
                                        break;
                                    }
                                }
                            }
                        }
                        ++k;
                    }
                    if (socialWelfare != null) {
                        Float winnerPerUFuncWelfare = (Float)winnersPerUFuncWelfare.get(i);
                        if (winnerPerUFuncWelfare == null) {
                            winnersPerUFuncWelfare.set(i, socialWelfare);
                            ((List)winnersPerUFunc.get(i)).add(j);
                        } else if (socialWelfare.equals(winnerPerUFuncWelfare)) {
                            ((List)winnersPerUFunc.get(i)).add(j);
                        } else if (socialWelfare.floatValue() > winnerPerUFuncWelfare.floatValue()) {
                            winnersPerUFuncWelfare.set(i, socialWelfare);
                            ((List)winnersPerUFunc.get(i)).clear();
                            ((List)winnersPerUFunc.get(i)).add(j);
                        }
                    }
                    ++j;
                }
                if (winnersPerUFuncWelfare.get(i) == null) {
                    this.logger.fine("Winner(s) of utility " + uFuncs.get(i) + ": None");
                } else {
                    this.logger.fine("Winner(s) of utility " + uFuncs.get(i) + ": [");
                    Iterator iterator = ((List)winnersPerUFunc.get(i)).iterator();
                    while (iterator.hasNext()) {
                        int allocId = (Integer)iterator.next();
                        this.logger.fine(allocs.get(allocId).toString());
                    }
                    this.logger.fine("] with Welfare: " + winnersPerUFuncWelfare.get(i));
                }
                ++i;
            }
            i = 0;
            while (i < uFuncs.size()) {
                if (winnersPerUFuncWelfare.get(i) != null) {
                    w = utilityWeights.get(uFuncs.get(i));
                    socialWelfare = w == null ? (Float)winnersPerUFuncWelfare.get(i) : Float.valueOf(((Float)winnersPerUFuncWelfare.get(i)).floatValue() * w.floatValue());
                    if (mademWinnersWelfare == null) {
                        mademWinnersWelfare = socialWelfare;
                        mademWinners.addAll((Collection)winnersPerUFunc.get(i));
                    } else if (socialWelfare.equals(mademWinnersWelfare)) {
                        mademWinners.addAll((Collection)winnersPerUFunc.get(i));
                    } else if (socialWelfare.floatValue() > mademWinnersWelfare.floatValue()) {
                        mademWinnersWelfare = socialWelfare;
                        mademWinners.clear();
                        mademWinners.addAll((Collection)winnersPerUFunc.get(i));
                    }
                }
                ++i;
            }
        }
        this.logger.fine("Madem Winner(s): [");
        winnersPerUFuncWelfare = mademWinners.iterator();
        while (winnersPerUFuncWelfare.hasNext()) {
            int allocId = (Integer)winnersPerUFuncWelfare.next();
            this.logger.fine(allocs.get(allocId).toString());
        }
        if (mademWinnersWelfare == null) {
            this.logger.fine("] with Welfare: None");
        } else {
            this.logger.fine("] with Welfare: " + mademWinnersWelfare);
        }
        Literal l = ASSyntax.createLiteral((String)"jmadem_result", (Term[])new Term[0]);
        l.addTerm((Term)new NumberTermImpl((double)id_decision));
        if (mademWinnersWelfare == null) {
            l.addTerm((Term)ASSyntax.createAtom((String)"none"));
            if (decision.getReturnWelfare()) {
                l.addTerm((Term)ASSyntax.createAtom((String)"none"));
            }
        } else {
            if (decision.isMultipleSolution()) {
                ListTermImpl listOfWinnerAllocations = new ListTermImpl();
                Iterator iterator = mademWinners.iterator();
                while (iterator.hasNext()) {
                    int allocId = (Integer)iterator.next();
                    listOfWinnerAllocations.add(allocs.get(allocId));
                }
                l.addTerm((Term)listOfWinnerAllocations);
            } else if (mademWinners.size() > 1) {
                int randomWinner = this.random.nextInt(mademWinners.size() - 1);
                Iterator itWinners = mademWinners.iterator();
                i = 0;
                while (i < randomWinner - 1) {
                    itWinners.next();
                    ++i;
                }
                l.addTerm(allocs.get((Integer)itWinners.next()));
            } else {
                l.addTerm(allocs.get((Integer)mademWinners.iterator().next()));
            }
            if (decision.getReturnWelfare()) {
                l.addTerm((Term)new NumberTermImpl((double)mademWinnersWelfare.floatValue()));
            }
        }
        if (timeout) {
            l.addAnnot((Term)ASSyntax.createAtom((String)"timeout"));
        }
        this.logger.fine("Add believe: " + l);
        try {
            this.getTS().getAg().addBel(l);
        }
        catch (Exception e) {
            this.logger.warning("Error adding believe " + l);
            e.printStackTrace();
        }
        this.logger.fine("Ending Winner Determination Problem.");
    }

    class BidTimeout
    extends TimerTask {
        int id_decision;

        public BidTimeout(int id) {
            this.id_decision = id;
        }

        public void run() {
            MADeMAgArch.this.logger.fine("Bid timeout reached for decision " + this.id_decision);
            MADeMAgArch.this.winnerDeterminationProblem(this.id_decision, true);
        }
    }
}

