/*
 * Decompiled with CFR 0.152.
 */
package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Literal;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Term;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import jmadem.Cuf;
import jmadem.MADeMAgArch;
import jmadem.Multimodality;

public class launch_specific_decision1_welfare
extends DefaultInternalAction {
    private static final long serialVersionUID = -5768570347409861849L;
    Logger logger = Logger.getLogger(launch_specific_decision1_welfare.class.getName());

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        try {
            ListTerm ags = (ListTerm)args[0];
            ListTerm allocs = (ListTerm)args[1];
            ListTerm uFuncs = (ListTerm)args[2];
            ConcurrentHashMap<Atom, Float> personalWeights = new ConcurrentHashMap<Atom, Float>();
            ConcurrentHashMap<Atom, Float> utilityWeights = new ConcurrentHashMap<Atom, Float>();
            for (Literal aux : (ListTerm)args[3]) {
                personalWeights.put((Atom)aux.getTerm(0), new Float(((NumberTerm)aux.getTerm(1)).solve()));
            }
            for (Literal aux : (ListTerm)args[4]) {
                utilityWeights.put((Atom)aux.getTerm(0), new Float(((NumberTerm)aux.getTerm(1)).solve()));
            }
            String name_welfare = ((Literal)args[5]).toString().toUpperCase();
            Cuf w = Enum.valueOf(Cuf.class, name_welfare);
            String name_multimodality = ((Literal)args[6]).toString().toUpperCase();
            Multimodality m = Enum.valueOf(Multimodality.class, name_multimodality);
            int tout = Float.valueOf((float)((NumberTerm)args[7]).solve()).intValue();
            if (allocs.size() == 0) {
                this.logger.severe("Error reading parameters: Allocations cannot be empty.");
                return false;
            }
            if (uFuncs.size() == 0) {
                this.logger.severe("Error reading parameters: Utility Functions cannot be empty.");
                return false;
            }
            if (ags.size() != personalWeights.size()) {
                this.logger.severe("Error reading parameters: Agents and Personal Weights mismatch.");
                return false;
            }
            if (uFuncs.size() != utilityWeights.size()) {
                this.logger.severe("Error reading parameters: Utility Functions and Utility Weights mismatch.");
                return false;
            }
            MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
            int id_decision = agArch.startMADeMDecision(ags, allocs, uFuncs, personalWeights, utilityWeights, w, m, tout, false, true);
            if (id_decision == -1) {
                return false;
            }
            return un.unifies(args[8], (Term)new NumberTermImpl((double)id_decision));
        }
        catch (Exception e) {
            this.logger.severe("Error reading parameters for starting MADeM.");
            e.printStackTrace();
            return false;
        }
    }
}

