/*
 * Decompiled with CFR 0.152.
 */
package busca;

import busca.Busca;
import busca.Estado;
import busca.MostraStatusConsole;
import busca.Nodo;
import java.util.LinkedList;

public class BuscaProfundidade
extends Busca {
    protected int profMax = 40;

    public BuscaProfundidade() {
    }

    public BuscaProfundidade(int m) {
        this.profMax = m;
    }

    public BuscaProfundidade(MostraStatusConsole ms) {
        super(ms);
    }

    public BuscaProfundidade(int m, MostraStatusConsole ms) {
        super(ms);
        this.profMax = m;
    }

    public void setProfMax(int m) {
        this.profMax = m;
    }

    public Nodo busca(Estado inicial) {
        this.status.inicia();
        this.initFechados();
        LinkedList<Nodo> abertos = new LinkedList<Nodo>();
        abertos.add(new Nodo(inicial, null));
        while (!this.parar && abertos.size() > 0) {
            Nodo n = (Nodo)abertos.remove(0);
            this.status.explorando(n, abertos.size());
            if (n.estado.ehMeta()) {
                this.status.termina(true);
                return n;
            }
            if (n.getProfundidade() >= this.profMax) continue;
            abertos.addAll(0, this.sucessores(n));
        }
        this.status.termina(false);
        return null;
    }

    public String toString() {
        return "BP - Busca em Profundidade";
    }
}

