/*
 * Decompiled with CFR 0.152.
 */
package busca;

import busca.BuscaHeuristica;
import busca.Estado;
import busca.MostraStatusConsole;
import busca.Nodo;
import java.util.PriorityQueue;

public class AEstrela
extends BuscaHeuristica {
    int maxF = -1;
    int maxAbertos = -1;
    Nodo theBest;

    public AEstrela() {
    }

    public AEstrela(MostraStatusConsole ms) {
        super(ms);
    }

    public void setMaxF(int m) {
        this.maxF = m;
    }

    public void setMaxAbertos(int m) {
        this.maxAbertos = m;
    }

    public Nodo getTheBest() {
        return this.theBest;
    }

    public Nodo busca(Estado inicial) {
        this.status.inicia();
        this.initFechados();
        PriorityQueue<Nodo> abertos = new PriorityQueue<Nodo>(100, this.getNodoComparatorF());
        Nodo nInicial = new Nodo(inicial, null);
        abertos.add(nInicial);
        this.theBest = nInicial;
        while (!this.parar && abertos.size() > 0) {
            Nodo melhor = (Nodo)abertos.remove();
            this.status.explorando(melhor, abertos.size());
            if (melhor.estado.ehMeta()) {
                this.status.termina(true);
                return melhor;
            }
            if (this.maxF < 0 || melhor.f() < this.maxF) {
                abertos.addAll(this.sucessores(melhor));
            }
            if (this.maxAbertos > 0 && abertos.size() > this.maxAbertos) break;
            if (melhor.f() >= this.theBest.f()) continue;
            this.theBest = melhor;
        }
        this.status.termina(false);
        return null;
    }

    public String toString() {
        return "A* - busca heur\u00ccstica";
    }
}

