/*
 * Decompiled with CFR 0.152.
 */
package busca;

import busca.Antecessor;
import busca.Estado;
import busca.MostraStatusConsole;
import busca.Nodo;
import busca.Status;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Busca {
    protected boolean parar = false;
    protected boolean podar = true;
    protected boolean usarFechado = true;
    protected Status status = new Status();
    protected MostraStatusConsole mstatus = null;
    private Map<Estado, Integer> fechados = null;

    public Busca() {
    }

    public Busca(MostraStatusConsole ms) {
        this.setMostra(ms);
    }

    protected void initFechados() {
        this.fechados = new HashMap<Estado, Integer>();
    }

    public Status getStatus() {
        return this.status;
    }

    public Status novoStatus() {
        this.status = new Status();
        if (this.mstatus != null) {
            this.mstatus.setStatus(this.status);
            this.status.setMostra(this.mstatus);
        }
        return this.status;
    }

    public void setMostra(MostraStatusConsole ms) {
        this.mstatus = ms;
        ms.setStatus(this.status);
        this.status.setMostra(ms);
    }

    public String toString() {
        return "Algoritmo de busca geral";
    }

    public abstract Nodo busca(Estado var1) throws Exception;

    public void setParar(boolean b) {
        this.parar = b;
    }

    public void para() {
        this.parar = true;
        this.status.termina(false);
    }

    public void setPodar(boolean b) {
        this.podar = b;
    }

    public void usarFechados(boolean b) {
        this.usarFechado = b;
    }

    public List<Nodo> sucessores(Nodo pai) {
        return this.soNovos(pai.estado.sucessores(), pai);
    }

    public List<Nodo> antecessores(Nodo pai) {
        try {
            return this.soNovos(((Antecessor)((Object)pai.estado)).antecessores(), pai);
        }
        catch (Exception e) {
            System.err.println("O estado " + pai.estado + " nao implementa antecessores!");
            return new LinkedList<Nodo>();
        }
    }

    private List<Nodo> soNovos(List<Estado> estados, Nodo pai) {
        LinkedList<Nodo> sucNodo = new LinkedList<Nodo>();
        for (Estado e : estados) {
            Nodo filho = new Nodo(e, pai);
            if (this.podar) {
                if (this.usarFechado && this.fechados != null) {
                    Integer custo = this.fechados.get(e);
                    if (custo != null && filho.g >= custo) continue;
                    sucNodo.add(filho);
                    this.fechados.put(e, filho.g);
                    continue;
                }
                if (!filho.ehDescendenteNovo(pai)) continue;
                sucNodo.add(filho);
                continue;
            }
            sucNodo.add(filho);
        }
        return sucNodo;
    }
}

