/*
 * Decompiled with CFR 0.152.
 */
package exemplos;

import busca.BuscaLargura;
import busca.Estado;
import busca.Nodo;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HLAC
implements Estado {
    char homem;
    char lobo;
    char carneiro;
    char alface;
    String op = "";

    @Override
    public String getDescricao() {
        return "Uma pessoa, um lobo, um carneiro e um cesto de alface est\u201eo \u2021 beira \nde um rio. Dispondo de um barco no qual pode carregar apenas um dos \noutros tr\u00cds, a pessoa deve transportar tudo para a outra margem. \nDetermine uma s\u00c8rie de travessias que respeite a seguinte condi\u00c1\u201eo: \nem nenhum momento devem ser deixados juntos e sozinhos o lobo e o \ncarneiro ou o carneiro e o cesto de alface. \n\n";
    }

    public HLAC(char h, char l, char c, char a, String o) {
        this.homem = h;
        this.lobo = l;
        this.carneiro = c;
        this.alface = a;
        this.op = o;
    }

    @Override
    public boolean ehMeta() {
        return this.homem == 'd' && this.lobo == 'd' && this.carneiro == 'd' && this.alface == 'd';
    }

    public boolean equals(Object o) {
        try {
            HLAC e = (HLAC)o;
            if (this.homem == e.homem && this.lobo == e.lobo && this.carneiro == e.carneiro && this.alface == e.alface) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public int hashCode() {
        return ("" + this.homem + this.lobo + this.carneiro + this.alface).hashCode();
    }

    @Override
    public List<Estado> sucessores() {
        LinkedList<Estado> suc = new LinkedList<Estado>();
        this.levarCarneiro('d', 'e', suc);
        this.levarCarneiro('e', 'd', suc);
        this.levarLobo('d', 'e', suc);
        this.levarLobo('e', 'd', suc);
        this.levarAlface('d', 'e', suc);
        this.levarAlface('e', 'd', suc);
        this.levarNada('d', 'e', suc);
        this.levarNada('e', 'd', suc);
        return suc;
    }

    private void levarCarneiro(char margemW, char margemZ, List<Estado> suc) {
        HLAC novo;
        if (this.carneiro == margemW && this.homem == margemW && (novo = new HLAC(margemZ, this.lobo, margemZ, this.alface, "levarC-" + margemW + margemZ)).ehValido()) {
            suc.add(novo);
        }
    }

    private void levarLobo(char margemW, char margemZ, List<Estado> suc) {
        HLAC novo;
        if (this.lobo == margemW && this.homem == margemW && (novo = new HLAC(margemZ, margemZ, this.carneiro, this.alface, "levarL-" + margemW + margemZ)).ehValido()) {
            suc.add(novo);
        }
    }

    private void levarAlface(char margemW, char margemZ, List<Estado> suc) {
        HLAC novo;
        if (this.alface == margemW && this.homem == margemW && (novo = new HLAC(margemZ, this.lobo, this.carneiro, margemZ, "levarL-" + margemW + margemZ)).ehValido()) {
            suc.add(novo);
        }
    }

    private void levarNada(char margemW, char margemZ, List<Estado> suc) {
        HLAC novo;
        if (this.homem == margemW && (novo = new HLAC(margemZ, this.lobo, this.carneiro, this.alface, "levarN-" + margemW + margemZ)).ehValido()) {
            suc.add(novo);
        }
    }

    private boolean ehValido() {
        if (this.lobo == this.carneiro && this.lobo != this.homem) {
            return false;
        }
        return this.carneiro != this.alface || this.carneiro == this.homem;
    }

    public String toString() {
        String dir = "";
        String esq = "";
        if (this.homem == 'd') {
            dir = String.valueOf(dir) + 'h';
        } else {
            esq = String.valueOf(esq) + 'h';
        }
        if (this.lobo == 'd') {
            dir = String.valueOf(dir) + 'l';
        } else {
            esq = String.valueOf(esq) + 'l';
        }
        if (this.carneiro == 'd') {
            dir = String.valueOf(dir) + 'c';
        } else {
            esq = String.valueOf(esq) + 'c';
        }
        if (this.alface == 'd') {
            dir = String.valueOf(dir) + 'a';
        } else {
            esq = String.valueOf(esq) + 'a';
        }
        return String.valueOf(esq) + "|" + dir + " (" + this.op + ")\n";
    }

    @Override
    public int custo() {
        return 1;
    }

    public static void main(String[] a) {
        HLAC inicial = new HLAC('e', 'e', 'e', 'e', "inicial");
        System.out.println("busca em largura");
        Nodo n = new BuscaLargura().busca(inicial);
        if (n == null) {
            System.out.println("sem solu\u00c1\u201eo!");
        } else {
            System.out.println("solu\u00c1\u201eo:\n" + n.montaCaminho() + "\n\n");
        }
    }
}

