/*
 * Decompiled with CFR 0.152.
 */
package exemplos;

import busca.Antecessor;
import busca.BuscaBidirecional;
import busca.BuscaIterativo;
import busca.BuscaLargura;
import busca.BuscaProfundidade;
import busca.Estado;
import busca.Nodo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissionarioCanibal
implements Estado,
Antecessor {
    int missionario = 3;
    int canibal = 3;
    char barco = (char)101;
    String op = "";

    @Override
    public String getDescricao() {
        return "Tr\u00cds misssion\u00b7rios e tr\u00cds canibais est\u201eo \u2021 beira de um rio e disp\u0131em de\num barco com capacidade para apenas duas pessoas. O problema \u00c8 determinar\nas tripula\u00c1\u0131es de uma s\u00c8rie de travessias de maneira que todo o grupo passe\npara o outro lado do rio, respeitada a condi\u00c1\u201eo de que em momento algum os\ncanibais sejam mais numerosos do que os mission\u00b7rios em uma das margens do rio.\n\nImplementa\u00c1\u201eo de Malcus Ot\u00b7vio Quinoto Imhof & Daniel Dalcastagne - 5\u222b Semestre Matutino - BCC\n\n";
    }

    public MissionarioCanibal(int m, int c, char b, String o) {
        if (m >= 0 && c >= 0) {
            this.missionario = m;
            this.canibal = c;
            this.barco = b;
            this.op = o;
        }
    }

    @Override
    public boolean ehMeta() {
        return this.missionario == 0 && this.canibal == 0;
    }

    @Override
    public int custo() {
        return 1;
    }

    @Override
    public List<Estado> sucessores() {
        LinkedList<Estado> suc = new LinkedList<Estado>();
        this.levar1m(suc);
        this.levar2m(suc);
        this.levar1m1c(suc);
        this.levar1c(suc);
        this.levar2c(suc);
        return suc;
    }

    @Override
    public List<Estado> antecessores() {
        return this.sucessores();
    }

    public boolean ehValido() {
        if (this.missionario < this.canibal && this.missionario != 0) {
            return false;
        }
        return 3 - this.missionario >= 3 - this.canibal || 3 - this.missionario == 0;
    }

    public void levar1m(List<Estado> suc) {
        MissionarioCanibal novo;
        if (this.barco == 'e' && this.missionario > 0) {
            MissionarioCanibal novo2 = new MissionarioCanibal(this.missionario - 1, this.canibal, 'd', "Levar 1 mission\u00b7rio para margem direita");
            if (novo2.ehValido()) {
                suc.add(novo2);
            }
        } else if (this.barco == 'd' && this.missionario < 3 && (novo = new MissionarioCanibal(this.missionario + 1, this.canibal, 'e', "Levar 1 mission\u00b7rio para margem esquerda")).ehValido()) {
            suc.add(novo);
        }
    }

    public void levar2m(List<Estado> suc) {
        MissionarioCanibal novo;
        if (this.barco == 'e' && this.missionario > 1) {
            MissionarioCanibal novo2 = new MissionarioCanibal(this.missionario - 2, this.canibal, 'd', "Levar 2 mission\u00b7rios para margem direita");
            if (novo2.ehValido()) {
                suc.add(novo2);
            }
        } else if (this.barco == 'd' && this.missionario < 2 && (novo = new MissionarioCanibal(this.missionario + 2, this.canibal, 'e', "Levar 2 mission\u00b7rios para margem esquerda")).ehValido()) {
            suc.add(novo);
        }
    }

    public void levar1m1c(List<Estado> suc) {
        MissionarioCanibal novo;
        if (this.barco == 'e' && this.missionario > 0 && this.canibal > 0) {
            MissionarioCanibal novo2 = new MissionarioCanibal(this.missionario - 1, this.canibal - 1, 'd', "Levar 1 mission\u00b7rio e 1 canibal para margem direita");
            if (novo2.ehValido()) {
                suc.add(novo2);
            }
        } else if (this.barco == 'd' && this.missionario < 3 && this.canibal < 3 && (novo = new MissionarioCanibal(this.missionario + 1, this.canibal + 1, 'e', "Levar 1 mission\u00b7rio e 1 canibal para margem esquerda")).ehValido()) {
            suc.add(novo);
        }
    }

    public void levar1c(List<Estado> suc) {
        MissionarioCanibal novo;
        if (this.barco == 'e' && this.canibal > 0) {
            MissionarioCanibal novo2 = new MissionarioCanibal(this.missionario, this.canibal - 1, 'd', "Levar 1 canibal para margem direita");
            if (novo2.ehValido()) {
                suc.add(novo2);
            }
        } else if (this.barco == 'd' && this.canibal < 3 && (novo = new MissionarioCanibal(this.missionario, this.canibal + 1, 'e', "Levar 1 canibal para margem esquerda")).ehValido()) {
            suc.add(novo);
        }
    }

    public void levar2c(List<Estado> suc) {
        MissionarioCanibal novo;
        if (this.barco == 'e' && this.canibal > 1) {
            MissionarioCanibal novo2 = new MissionarioCanibal(this.missionario, this.canibal - 2, 'd', "Levar 2 canibais para margem direita");
            if (novo2.ehValido()) {
                suc.add(novo2);
            }
        } else if (this.barco == 'd' && this.canibal < 2 && (novo = new MissionarioCanibal(this.missionario, this.canibal + 2, 'e', "Levar 2 canibais para margem esquerda")).ehValido()) {
            suc.add(novo);
        }
    }

    public String toString() {
        String dir = "";
        String esq = "";
        if (this.missionario == 3) {
            esq = String.valueOf(esq) + "MMM";
        }
        if (this.missionario == 2) {
            esq = String.valueOf(esq) + "MM";
            dir = String.valueOf(dir) + "M";
        }
        if (this.missionario == 1) {
            esq = String.valueOf(esq) + "M";
            dir = String.valueOf(dir) + "MM";
        }
        if (this.missionario == 0) {
            dir = String.valueOf(dir) + "MMM";
        }
        if (this.canibal == 3) {
            esq = String.valueOf(esq) + "CCC";
        }
        if (this.canibal == 2) {
            esq = String.valueOf(esq) + "CC";
            dir = String.valueOf(dir) + "C";
        }
        if (this.canibal == 1) {
            esq = String.valueOf(esq) + "C";
            dir = String.valueOf(dir) + "CC";
        }
        if (this.canibal == 0) {
            dir = String.valueOf(dir) + "CCC";
        }
        if (this.barco == 'e') {
            esq = String.valueOf(esq) + 'B';
        } else {
            dir = String.valueOf(dir) + 'B';
        }
        return String.valueOf(esq) + "|" + dir + "( " + this.op + " )" + "\n";
    }

    public static void main(String[] a) throws IOException {
        MissionarioCanibal inicial = new MissionarioCanibal(3, 3, 'e', "");
        MissionarioCanibal finau = new MissionarioCanibal(0, 0, 'd', "");
        BufferedReader teclado = new BufferedReader(new InputStreamReader(System.in));
        Nodo n = null;
        System.out.print("Digite sua op\u00c1\u201eo de busca { Digite S para finalizar }\n");
        System.out.print("\t1  -  Largura\n");
        System.out.print("\t2  -  Profundidade\n");
        System.out.print("\t3  -  Pronfundidade Iterativo\n");
        System.out.print("\t4  -  Bidirecional\n");
        System.out.print("Op\u00c1\u201eo: ");
        String str = teclado.readLine().toUpperCase();
        while (!str.equals("S")) {
            if (str.equals("1")) {
                System.out.println("Busca em Largura");
                n = new BuscaLargura().busca(inicial);
            } else if (str.equals("2")) {
                System.out.println("Busca em Profundidade");
                n = new BuscaProfundidade(20).busca(inicial);
            } else if (str.equals("3")) {
                System.out.println("Busca em Profundidade Iterativo");
                n = new BuscaIterativo().busca(inicial);
            } else if (str.equals("4")) {
                System.out.println("Busca Bidirecional");
                n = new BuscaBidirecional().busca(inicial, finau);
            }
            if (str.equals("1") || str.equals("2") || str.equals("3") || str.equals("4")) {
                if (n == null) {
                    System.out.println("Sem Solu\u00c1\u201eo!");
                } else {
                    System.out.println("Solu\u00c1\u201eo:\n" + n.montaCaminho() + "\n\n");
                }
            }
            System.out.print("Digite sua op\u00c1\u201eo de busca { Digite S para finalizar }\n");
            System.out.print("\t1  -  Largura\n");
            System.out.print("\t2  -  Profundidade\n");
            System.out.print("\t3  -  Pronfundidade Iterativo\n");
            System.out.print("\t4  -  Bidirecional\n");
            System.out.print("Op\u00c1\u201eo: ");
            str = teclado.readLine().toUpperCase();
        }
    }

    public boolean equals(Object o) {
        try {
            MissionarioCanibal e = (MissionarioCanibal)o;
            if (this.missionario == e.missionario && this.canibal == e.canibal && this.barco == e.barco) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public int hashCode() {
        return (String.valueOf(this.missionario) + "," + this.canibal + this.barco).hashCode();
    }
}

