/*
 * Decompiled with CFR 0.152.
 */
package grafo;

import grafo.Aresta;
import grafo.ArestaValorada;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertice {
    Set<Aresta> arestas = new HashSet<Aresta>();
    private int id;

    public Vertice(int id) {
        this.id = id;
    }

    public void addAresta(Aresta a) {
        this.arestas.add(a);
    }

    public int getId() {
        return this.id;
    }

    public List<Vertice> getAdjacentes() {
        ArrayList<Vertice> adj = new ArrayList<Vertice>();
        for (Aresta a : this.arestas) {
            if (a.vi == this) {
                adj.add(a.vj);
                continue;
            }
            adj.add(a.vi);
        }
        return adj;
    }

    public Map<Vertice, Integer> getCustoAdjacentes() {
        HashMap<Vertice, Integer> adj = new HashMap<Vertice, Integer>();
        for (Aresta a : this.arestas) {
            ArestaValorada ac = (ArestaValorada)a;
            if (a.vi == this) {
                adj.put(a.vj, ac.getCusto());
                continue;
            }
            adj.put(a.vi, ac.getCusto());
        }
        return adj;
    }

    public Set<Aresta> getArestas() {
        return this.arestas;
    }

    public String toString() {
        return String.valueOf(this.id);
    }
}

