// boss agent

{ include("../../asl/jmadem.asl") }      // J-MADeM Plan Library 

/* beliefs */

last_dir(null). // the last movement I did

/* rules */

// next line is the bottom of the quadrant
// if 2 lines bellow is too far
calc_new_y(AgY,QuadY2,QuadY2) :- AgY+2 > QuadY2.

// otherwise, the next line is 2 lines bellow
calc_new_y(AgY,_,Y) :- Y = AgY+2.


/* plans for sending the initial position to leader and get the quadrant */

+gsize(S,W,H,_,_) : true // S is the simulation Id 
  <- !send_init_pos(S).
+!send_init_pos(S) : pos(X,Y)
  <- .send(leader,tell,init_pos(S,X,Y)).
+!send_init_pos(S) : not pos(_,_) // if I do not know my position yet
  <- .wait("+pos(X,Y)", 500);     // wait for it and try again
     !!send_init_pos(S).
	 
+quadrant(_,_,_,_) : .my_name(AgName)
  <- .broadcast(tell, boss(AgName)).
	 
+boss_of(MinerName) : quadrant(X1,Y1,X2,Y2)
  <- .send(MinerName,tell,quadrant(X1,Y1,X2,Y2)).
  
/* plans for wandering in my quadrant when I'm free */

+free : last_checked(X,Y)     <- !prep_around(X,Y).
+free : quadrant(X1,Y1,X2,Y2) <- !prep_around(X1,Y1).
+free : true                  <- !wait_for_quad.

@pwfq[atomic]
+!wait_for_quad : free & quadrant(_,_,_,_) 
   <- -+free.
+!wait_for_quad : free     
   <- .wait("+quadrant(X1,Y1,X2,Y2)", 500); 
      !!wait_for_quad.
+!wait_for_quad : not free 
   <- .print("No longer free while waiting for quadrant.").
-!wait_for_quad // .wait might fail     
   <- !!wait_for_quad.

// if I am around the upper-left corner, move to upper-right corner
+around(X1,Y1) : quadrant(X1,Y1,X2,Y2) & free
  <- //.print("in Q1 to ",X2,"x",Y1); 
     !prep_around(X2,Y1).

// if I am around the bottom-right corner, move to upper-left corner
+around(X2,Y2) : quadrant(X1,Y1,X2,Y2) & free 
  <- //.print("in Q4 to ",X1,"x",Y1); 
     !prep_around(X1,Y1).

// if I am around the right side, move to left side two lines bellow
+around(X2,Y) : quadrant(X1,Y1,X2,Y2) & free  
  <- ?calc_new_y(Y,Y2,YF);
     //.print("in Q2 to ",X1,"x",YF);
     !prep_around(X1,YF).

// if I am around the left side, move to right side two lines bellow
+around(X1,Y) : quadrant(X1,Y1,X2,Y2) & free  
  <- ?calc_new_y(Y,Y2,YF);
     //.print("in Q3 to ", X2, "x", YF); 
     !prep_around(X2,YF).

// last "around" was none of the above, go back to my quadrant
+around(X,Y) : quadrant(X1,Y1,X2,Y2) & free & Y <= Y2 & Y >= Y1  
  <- //.print("in no Q, going to X1");
     !prep_around(X1,Y).
+around(X,Y) : quadrant(X1,Y1,X2,Y2) & free & X <= X2 & X >= X1  
  <- //.print("in no Q, going to Y1");
     !prep_around(X,Y1).

+around(X,Y) : quadrant(X1,Y1,X2,Y2)
  <- //.print("It should never happen!!!!!! - go home");
     !prep_around(X1,Y1).

+!prep_around(X,Y) : free
  <- -around(_,_); -last_dir(_); !around(X,Y).
 
+!around(X,Y) 
   :  // I am around to some location if I am near it or
      // the last action was skip (meaning that there are no paths to there)
      (pos(AgX,AgY) & jia.neighbour(AgX,AgY,X,Y)) | last_dir(skip) 
   <- +around(X,Y).
+!around(X,Y) : not around(X,Y)
   <- !next_step(X,Y);
      !!around(X,Y).
+!around(X,Y) : true 
   <- !!around(X,Y).

+!next_step(X,Y)
   :  pos(AgX,AgY)
   <- jia.get_direction(AgX, AgY, X, Y, D);
      //.print("from ",AgX,"x",AgY," to ", X,"x",Y," -> ",D);
      -+last_dir(D);
      do(D).
+!next_step(X,Y) : not pos(_,_) // I still do not know my position
   <- !next_step(X,Y).
-!next_step(X,Y) : true  // failure handling -> start again!
   <- //.print("Failed next_step to ", X,"x",Y," fixing and trying again!");
      -+last_dir(null);
      !next_step(X,Y).

+cell(X,Y,gold) 
  <- +gold(X,Y).

/* Plans to assign golds to workers */
+gold(X,Y) : committed_to(gold(X,Y))
  <-  -gold(X,Y)[source(_)].

@pgold[atomic]
+gold(X,Y) : .findall(Ag, boss_of(Ag), LWorkers) & LWorkers \== []
  <- // Auctioning of the gold
     .print("Auctioning ",gold(X,Y)," to workers ", LWorkers);
	 !jmadem_construct_allocations(gold(X,Y,Ag), boss_of(Ag), Alloc);
	 !jmadem_launch_decision1(LWorkers, Alloc, [goldDistance], DecisionId);
	 +jmadem_waiting(DecisionId, gold(X,Y)).
+gold(X,Y) : .findall(Ag, boss_of(Ag), LWorkers) & LWorkers == []
  <- .print("No workers for gold(", X, ",", Y, ")");
	 !!ask_bosses(gold(X,Y)).
	 
+jmadem_result(Id, gold(X,Y,Ag)) 
  <- .abolish(jmadem_result(Id,_));
     .abolish(jmadem_waiting(Id,_));
	 -gold(X,Y)[source(_)];
     Gold = gold(X,Y);
	 .print("Received MADEM result: ", Gold, " - ", Ag);
     .send(Ag,tell,allocated(Gold,Ag)).
+jmadem_result(Id, none) : jmadem_waiting(Id, gold(X,Y))
  <- .abolish(jmadem_result(Id,_));
     .abolish(jmadem_waiting(Id,_));
     .print("MADEM no result for Id: ", Id, " - gold(", X, ",", Y, ")");
	 !!ask_bosses(gold(X,Y)).
	 
	 
// someone else picked up a gold I know about, 
// remove from my belief base
@pp[atomic]
+picked(gold(X,Y))
  <- .abolish(picked(gold(X,Y)));
  	 .abolish(committed_to(gold(X,Y)));
     .abolish(gold(X,Y)).

/* Some miner is free. Put it to work */
@f1[atomic]
+free(Miner) [source(_)]: gold(X,Y) & not committed_to(gold(X,Y))
  <- .abolish(gold(X,Y));
     +gold(X,Y).

@f2[atomic]
+free(Miner) [source(_)]: not gold(X,Y) & .my_name(Me)
  <- .broadcast(tell, free_boss(Me)).

@f3[atomic]
+free_boss(_) [source(_)]: gold(X,Y) & not committed_to(gold(X,Y))
  <- .abolish(gold(X,Y));
     +gold(X,Y);
  	 -free_boss(_).
	 
/* Plans to assign golds to other bosses */
@pab1[atomic]
+!ask_bosses(gold(X,Y)) : .findall(Ag, boss(Ag), LBosses) & LBosses \== []
  <- // Auctioning of the minner
	 !jmadem_construct_allocations(get_miner_from(X,Y,Ag), boss(Ag), Alloc);  // Case 2
	 !jmadem_launch_decision1(LBosses, Alloc, [freeWorkers], DecisionId);
	 +jmadem_waiting(DecisionId, get_miner_for(X,Y)).
+!ask_bosses(gold(X,Y))   // if I do not know the name of the bosses yet
  <- .wait(500);          // wait for them and try again
     !!ask_bosses(gold(X,Y)).

/* Ask another boss for a foreign miner */
+jmadem_result(Id, get_miner_from(X,Y,Ag)) 
  <- .abolish(jmadem_result(Id,_));
     .abolish(jmadem_waiting(Id,_));
	 -gold(X,Y)[source(_)];
  	 .print("Received MADEM result: get_miner_from(", Ag, ")");
     .send(Ag, achieve,get_miner_for(X,Y)).
+jmadem_result(Id, none) : jmadem_waiting(Id, get_miner_for(X,Y))
  <- .abolish(jmadem_result(Id,_));
     .abolish(jmadem_waiting(Id,_));
	 .print("MADEM no result for Id: ", Id, " - get_miner_for(", X, ",", Y, ")").

+!get_miner_for(X,Y)[source(Boss)] : free(Ag)
  <- -boss_of(Ag)[source(_)];
  	 -free(Ag)[source(_)];
     .print("Pass miner ", Ag, " to ", Boss);
     .send(Ag, achieve, change_boss(Boss,X,Y)).
+!get_miner_for(X,Y)[source(Boss)] : not free(_)
  <- .println("No miners free for gold(", X, ",", Y, ")");
     .send(Boss, tell, gold(X,Y) ).

/* J-MADeM utility functions */
// distanceTo: returns the boss' preference to be the leader of a miner as:
//               MAX_DISTANCE(e.g.1000)-distance_to_miner 
+!jmadem_utility(distanceTo,_,leader(X,Y,AgName), Distance) : .my_name(AgName)
  <-?pos(MyX, MyY);
    jia.dist(MyX,MyY,X,Y,Dist2Miner);
    Distance = 1000 - Dist2Miner.
-!jmadem_utility(distanceTo,_,_,0). 
+!jmadem_utility(distanceTo,_,leader(X,Y,AgName), none) : .my_name(MyName) & MyName \== AgName.

// freeWorkers: returns the boss' preference to lend a miner from its group as
//              the number of leadered workers that are free or none if no miner is free
+!jmadem_utility(freeWorkers,_,get_miner_from(X,Y,AgName), .count(free(_))) : .my_name(AgName).
+!jmadem_utility(freeWorkers,_,get_miner_from(X,Y,AgName), none) : .my_name(MyName) & MyName \== AgName.
	 
+end_of_simulation(S,_)
  <- .drop_all_desires; 
     .abolish(quadrant(_,_,_,_));
     .abolish(gold(_,_));
     .abolish(committed_to(_));
     .abolish(picked(_));
     .abolish(last_checked(_,_));
     .print("-- END ",S," --");
	 endOfSimulation(0).

