/* J-MADeM Plan Library */
{ include("../../../asl/jmadem.asl") } 


/* Initial beliefs */
delay(1000).
day(monday).
day(tuesday).

hour(9).
hour(11).
hour(15).

jmadem_welfare(utilitarian).
sum_weighted_sw(monomodal,0).
sum_weighted_sw(multimodal,0).
sum_weighted_attendants(monomodal,0).
sum_weighted_attendants(multimodal,0).
sum_meeting_weights(0).


/* Initial goal */
!init. 


/* Plans */

// Set up plan
+!init : delay(Delay)
   <- .print("Waiting for workers...");
      .wait(Delay);
      !scheduleMeeting(1). 
	  
// Schedule a new meeting	  
+!scheduleMeeting(MeetingId) : delay(Delay) & sum_meeting_weights(SMW)
   <- //WMeeting = math.random;
      WMeeting = 1;
      WLaboral = math.random(WMeeting);
	  WPersonal = WMeeting - WLaboral;
	  NewSMW = SMW + WMeeting;
	  -+sum_meeting_weights(NewSMW);
	  +meeting(MeetingId,WMeeting,monomodal);
	  .abolish(jmadem_utility_weight(_,_));
	  +jmadem_utility_weight(laboralUF,WMeeting);
	  .print("Scheduling the meeting ", MeetingId, " (monomodal - W=",WMeeting,")");
	  .findall(Ag, worker(Ag), LWorkers);
      !jmadem_construct_allocations(meeting(MeetingId,Day,Hour), day(Day) & hour(Hour), Allocs);
	  !jmadem_launch_decision1_welfare(LWorkers, Allocs, [laboralUF],_);
	  .wait(Delay);
	  MeetingId2 = MeetingId + 1;
	  +meeting(MeetingId2,WMeeting,multimodal);
	  +jmadem_utility_weight(laboralUF,WLaboral);
	  +jmadem_utility_weight(generalUF,WPersonal);
	  .print("Scheduling the meeting ", MeetingId2, " (multimodal - WLab=",WLaboral," - WGen=",WPersonal,"))");
      !jmadem_construct_allocations(meeting(MeetingId2,Day,Hour), day(Day) & hour(Hour), Allocs2);
	  //!jmadem_launch_decision1_welfare(LWorkers, Allocs2, [laboralUF,personalUF],_);
	  !jmadem_launch_decision1_welfare(LWorkers, Allocs2, [generalUF,laboralUF],_);
	  .wait(Delay);
	  NextMeetingId = MeetingId2 + 1;
	  !!scheduleMeeting(NextMeetingId).
	  
// Notify workers
+jmadem_result(_, meeting(MeetingId,Day,Hour), SW) 
  : meeting(MeetingId,WMeeting,Mode) & sum_weighted_sw(Mode,SWSW) &  
    sum_weighted_attendants(Mode, SWA) & sum_meeting_weights(SMW)
  <- .abolish(meeting(MeetingId,_,_));
     .abolish(sum_weighted_sw(Mode,_));
	 .abolish(sum_weighted_attendants(Mode,_));
     NewSWSW = SWSW + WMeeting * SW;
	 +sum_weighted_sw(Mode,NewSWSW);
	 .print("MeetingId ", MeetingId, " (",Mode,") scheduled on : ", Day, "-", Hour, " (SW=", SW, ")");
     .print("N_SW_", Mode, " = ",  NewSWSW/SMW);
	 .findall(Ag, worker(Ag), LWorkers);
	 for ( .member(Worker,LWorkers) )
	 {
	   .send(Worker,askOne,attend(MeetingId,Day,Hour,Attend),attend(MeetingId,Day,Hour,Attend));
	   +attend(MeetingId,Worker,Attend);
	 }
	 .findall(Attend, attend(MeetingId,_,Attend), LAttends);
	 NewSWA = SWA + WMeeting * math.sum(LAttends);
	 +sum_weighted_attendants(Mode,NewSWA);
	 .abolish(attend(MeetingId,_,_));
	 .print("N_SWA_", Mode, " = ",  NewSWA/SMW);
	 if (MeetingId mod 2 > 0)
	 {
	   log_monomodal_sw(NewSWSW/SMW);
	   log_monomodal_att(NewSWA/SMW);
	 }
	 else
	 {
	   log_multimodal_sw(NewSWSW/SMW);
	   log_multimodal_att(NewSWA/SMW);
	 }.
+jmadem_result(Id, none,_) 
  <- .print("MeetingId ", Id, " cannot be scheduled!").

