/* J-MADeM Plan Library */
{ include("../../../asl/jmadem.asl") } 


/* Initial goal */
!init. 


/* Plans */

// Set up plan
+!init : .my_name(MyName)
   <- .send(director,tell,worker(MyName)).
   
// generalUF: returns a random  
// Alloc == meeting(MeetingId,Day,Hour)
jmadem_utility(generalUF,_,meeting(_,Day,Hour), Min) 
   :- .findall(V, constraint(_,Day,Hour,V), LValues) & .min(LValues, Min).

jmadem_utility(laboralUF,_,meeting(_,Day,Hour), Min) 
   :- .findall(V, constraint(laboral,Day,Hour,V), LValues) & .min(LValues, Min).

jmadem_utility(personalUF,_,meeting(_,Day,Hour), Min)
   :- .findall(V, constraint(personal,Day,Hour,V), LValues) & .min(LValues, Min).

jmadem_utility(_,_,_,1) :- true.

// Attendance plan
+?attend(_,Day,Hour,Attend) : constraint(_,Day,Hour,_)  
   <- .findall(V, constraint(_,Day,Hour,V), LValues);
      .min(LValues, Min);
      if (math.random < Min)
      {  
        Attend = 1
	  } else {
	    Attend = 0
	  }.
+?attend(_,Day,Hour,1) : not constraint(_,Day,Hour,_).  


