package env;

import jason.asSyntax.*;
import jason.environment.Environment;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;


public class PreferenceMeetingsEnv extends Environment {   

	static Logger logger = Logger.getLogger(PreferenceMeetingsEnv.class.getName());
	
    DefaultXYDataset datasetSW = new DefaultXYDataset();
    DefaultXYDataset datasetAtt = new DefaultXYDataset();

    List<Double> monomodalSW = new ArrayList<Double>();
    List<Double> multimodalSW = new ArrayList<Double>();
    List<Double> monomodalAtt = new ArrayList<Double>();
    List<Double> multimodalAtt = new ArrayList<Double>();

    @Override
	public void init(String[] args) {
		super.init(args);
		
        JFreeChart att = ChartFactory.createXYLineChart( 
                "Performance of Meeting Scheduling Problem (Attendants)",
                "Meetings scheduled",
                "Weighted success ratio (Attendants)",
                datasetAtt, // dataset, 
                PlotOrientation.VERTICAL, // orientation, 
                true, // legend, 
                true, // tooltips, 
                true); //urls
        ChartFrame frameAtt = new ChartFrame("Meeting Scheduling Problem", att); 
        frameAtt.setLocation(0,0);
        frameAtt.pack(); 
        frameAtt.setVisible(true); 

        JFreeChart sw = ChartFactory.createXYLineChart( 
                "Performance of Meeting Scheduling Problem (SW)",
                "Meetings scheduled",
                "Weighted success ratio (SW)",
                datasetSW, // dataset, 
                PlotOrientation.VERTICAL, // orientation, 
                true, // legend, 
                true, // tooltips, 
                true); //urls
        ChartFrame frameSW = new ChartFrame("Meeting Scheduling Problem", sw); 
        frameSW.setLocation(0,frameAtt.getHeight());
        frameSW.pack(); 
        frameSW.setVisible(true); 
    }

	
    @Override
	public boolean executeAction(String ag, Structure action) 
	{
		if (action.getFunctor().equals("log_monomodal_sw")){
			// Read parameters
			// log_monomodal_sw(MonomodalSW) 
			monomodalSW.add( ((NumberTerm)action.getTerm(0)).solve() );
			datasetSW.addSeries("Monomodal", getData(monomodalSW));
		}
		else if (action.getFunctor().equals("log_multimodal_sw")) {
			// Read parameters
			// log_multimodal_sw(MultimodalSW) 
			multimodalSW.add( ((NumberTerm)action.getTerm(0)).solve() );
			datasetSW.addSeries("Multimodal", getData(multimodalSW));
		}
	    else if (action.getFunctor().equals("log_monomodal_att")) {
			// Read parameters
			// log_monomodal_att(MonomodalAtt) 
			monomodalAtt.add( ((NumberTerm)action.getTerm(0)).solve() );
			datasetAtt.addSeries("Monomodal", getData(monomodalAtt));
	    }
		else if (action.getFunctor().equals("log_multimodal_att")) {
			// Read parameters
			// log_multimodal_att(MultimodalAtt) 
			multimodalAtt.add( ((NumberTerm)action.getTerm(0)).solve() );
			datasetAtt.addSeries("Multimodal", getData(multimodalAtt));
		} else {
		   	return false;
	    }

		return true;
	}
	
    private double[][] getData(List<Double> values) {
        double[][] r = new double[2][values.size()];
        int i = 0;
        for (double v: values) {
            r[0][i] = i;
            r[1][i] = v;
            i++;
        }
        return r;
    }


}
