
// Test agent

{ include("../../asl/jmadem.asl") }      // J-MADeM Plan Library 


/* 
   Beliefs and rules
*/
ag(fernando).
ag(miguel).
ag(fran).
ag(alejandro).
ag(testAgent).

jmadem_filter(skipFran, use(_, Agent)) :- Agent == fran.
jmadem_filter(skipTestAgent, use(_, testAgent)).


/*
   Initial goal
*/
!all_tests.



/*
   Test plans
*/

// Plan performing all tests (comment those you are not interested in)
+!all_tests
  <- .wait(1000);
     !!test_asl_construct_allocations;
     .wait(1000);
     !!test_asl_filter_allocations;
   	 .wait(1000);
     !!test_asl_set_welfare;
  	 .wait(1000);
     !!test_set_welfare;
	 .wait(1000);
     !!test_asl_set_timeout;
  	 .wait(1000);
     !!test_set_timeout;
  	 .wait(1000);
     !!test_asl_set_personal_weights;
  	 .wait(1000);
     !!test_set_personal_weights;
  	 .wait(1000);
     !!test_asl_set_utility_weights;
  	 .wait(1000);
     !!test_set_utility_weights;
  	 .wait(1000);
     !!test_asl_launch_decision1;
  	 .wait(1000);
     !!test_asl_launch_decision;
  	 .wait(1000);
     !!test_asl_launch_decision_none;
  	 .wait(1000);
     !!test_launch_decision1;
  	 .wait(1000);
     !!test_launch_decision;
     .wait(1000);
     !!test_asl_launch_specific_decision1;
     .wait(1000);
     !!test_asl_launch_specific_decision;
  	 .wait(1000);
     !!test_launch_specific_decision1;
  	 .wait(1000);
     !!test_launch_specific_decision.
	 
	 
// Tests for constructing allocations
+!test_asl_construct_allocations
  <- .println("Initiating AgentSpeak test for jmadem_construct_allocations");
     TaskSlot = use(coffeeMachine, Agent);
	 Elements = ag(Agent);
     !jmadem_construct_allocations(TaskSlot, Elements, Allocations);
     .println("Constructed allocations 1: ", Allocations);
	 Elements2 = (ag(Agent) & Agent \== fran);
     !jmadem_construct_allocations(TaskSlot, Elements2, Allocations2);
     .println("Constructed allocations 2: ", Allocations2);
	 .println("Successful AgentSpeak test for jmadem_construct_allocations").
-!test_asl_construct_allocations
  <- .println("Failed AgentSpeak test for jmadem_construct_allocations").
  
// Test for filtering allocations
+!test_asl_filter_allocations
  <- .println("Initiating AgentSpeak test for jmadem_filter_allocations");
     TaskSlot = use(coffeeMachine, Agent);
	 Elements = ag(Agent);
     !jmadem_construct_allocations(TaskSlot, Elements, Allocations);
     .println("Constructed allocations: ", Allocations);
     !jmadem_filter_allocations(skipFran, Allocations, FilteredAllocations1);
     .println("Filtered allocations by skipFran: ", FilteredAllocations1);
     !jmadem_filter_allocations(skipTestAgent, Allocations, FilteredAllocations2);
     .println("Filtered allocations by skipTestAgent: ", FilteredAllocations2);
	 FilterNames = [skipFran, skipTestAgent];
     !jmadem_filter_allocations(FilterNames, Allocations, FilteredAllocations3);
     .println("Filtered allocations by [skipFran, skipTestAgent]: ", FilteredAllocations3);
	 .println("Successful AgentSpeak test for jmadem_filter_allocations").
-!test_asl_filter_allocations
  <- .println("Failed AgentSpeak test for jmadem_filter_allocations").
+!filter(skipTestAgent, use(_, Agent)) <- Agent == testAgent.
  
// Tests for setting/getting the welfare
+!test_asl_set_welfare 
  <- .println("Initiating AgentSpeak test for jmadem.set_welfare()");
     +jmadem_welfare(utilitarian);
     ?jmadem_welfare(W);
	 .println("Welfare set to: ", W);
     -jmadem_welfare(utilitarian);
	 .println("Welfare reset to: elitist");
	 .println("Successful AgentSpeak test for jmadem.set_welfare()").
-!test_asl_set_welfare 
  <- .println("Failed AgentSpeak test for jmadem.set_welfare()").
+!test_set_welfare 
  <- .println("Initiating test for jmadem.set_welfare()");
     jmadem.set_welfare(utilitarian);
	 jmadem.set_welfare(egalitarian);
	 jmadem.set_welfare(elitist);
	 jmadem.set_welfare(nash);
	 Welfare = utilitarian;
     jmadem.set_welfare(Welfare); 
	 jmadem.get_welfare(W);
	 .println("Welfare set to: ", W);
	 .println("Successful test for jmadem.set_welfare()").
-!test_set_welfare 
  <- .println("Failed test for jmadem.set_welfare()").

// Tests for setting/getting the timeout 
+!test_asl_set_timeout 
  <- .println("Initiating AgentSpeak test for jmadem.set_timeout()");
     +jmadem_timeout(500);
     ?jmadem_timeout(Timeout); 
	 .println("Timeout set to: ", Timeout);
     -jmadem_timeout(500);
	 .println("Timeout reset to: 1000ms");
	 .println("Successful AgentSpeak test for jmadem.set_timeout()").
-!test_asl_set_timeout 
  <- .println("Failed AgentSpeak test for jmadem.set_timeout()").
+!test_set_timeout 
  <- .println("Initiating test for jmadem.set_timeout()");
     jmadem.set_timeout(500); 
     jmadem.set_timeout(1.5); 
     jmadem.set_timeout(2000); 
	 Timeout = 1000;
     jmadem.set_timeout(Timeout); 
	 jmadem.get_timeout(T);
	 .println("Timeout set to: ", T);
	 .println("Successful test for jmadem.set_timeout()").
-!test_set_timeout 
  <- .println("Failed test for jmadem.set_timeout()").

// Tests for setting/getting the personal weights
+!test_asl_set_personal_weights 
  <- .println("Initiating AgentSpeak test for jmadem.set_personal_weights()");
     +jmadem_personal_weight(fernando,0.25);
     ?jmadem_personal_weight(AgName,Weight);
	 .println("Personal weight of ", AgName," set to: ", Weight);
     -jmadem_personal_weight(AgName,Weight);
	 .println("Personal weight of ", AgName," reset to 1");
     PW = [jmadem_personal_weight(fernando,0.25),jmadem_personal_weight(miguel,0.5),jmadem_personal_weight(fran,0.25)];
     +jmadem_list_of_personal_weights(PW);
     ?jmadem_list_of_personal_weights(L);
	 .println("Personal weights set for: ", L);
	 .println("Successful AgentSpeak test for jmadem.set_personal_weights()").
-!test_asl_set_personal_weights 
  <- .println("Failed AgentSpeak test for jmadem.set_personal_weights()").
+!test_set_personal_weights 
  <- .println("Initiating test for jmadem.set_personal_weights()");
     jmadem.set_personal_weight(fernando,0.25); 
     jmadem.get_personal_weight(fernando, W);
     .println("Personal weight of fernando set to: ", W);
	 PW = [jmadem_personal_weight(miguel,0.5),jmadem_personal_weight(fran,0.25)];
     jmadem.set_list_of_personal_weights(PW); 
	 jmadem.get_list_of_personal_weights(L);
	 .println("Personal weights set to: ", L);
	 .println("Successful test for jmadem.set_personal_weights()").
-!test_set_personal_weights 
  <- .println("Failed test for jmadem.set_personal_weights()").

// Tests for setting/getting the utility weights 
+!test_asl_set_utility_weights 
  <- .println("Initiating AgentSpeak test for jmadem.set_utility_weights()");
	 +jmadem_utility_weight(minimumUtilityFunction,0.25);
     ?jmadem_utility_weight(UName,Weight);
	 .println("Utility weight of ", UName," set to: ", Weight);
     -jmadem_utility_weight(UName,Weight);
	 .println("Utility weight of ", UName," reset to 1");
	 UW = [jmadem_utility_weight(minimumUtilityFunction,0.25),jmadem_utility_weight(maximumUtilityFunction,0.75)];
     +jmadem_list_of_utility_weights(UW); 
	 ?jmadem_list_of_utility_weights(L);
	 .println("Utility weights set to: ", L);
	 .println("Successful AgentSpeak test for jmadem.set_utility_weights()").
-!test_asl_set_utility_weights 
  <- .println("Failed AgentSpeak test for jmadem.set_utility_weights()").
+!test_set_utility_weights 
  <- .println("Initiating test for jmadem.set_utility_weights()");
     jmadem.set_utility_weight(minimumUtilityFunction, 1);
     jmadem.get_utility_weight(minimumUtilityFunction, W);
     .println("Utility weight of minimumUtilityFunction set to: ", W);
	 UW = [jmadem_utility_weight(minimumUtilityFunction,0.25),jmadem_utility_weight(maximumUtilityFunction,0.75)];
     jmadem.set_list_of_utility_weights(UW); 
	 jmadem.get_list_of_utility_weights(L);
	 .println("Utility weights set to: ", L);
	 .println("Successful test for jmadem.set_utility_weights()").
-!test_set_utility_weights 
  <- .println("Failed test for jmadem.set_utility_weights()").

// Tests for invoking MADeM decisions 
+!test_asl_launch_decision1
  <- .println("Initiating AgentSpeak test for jmadem.launch_decision1()");
  	 +jmadem_utility_function(minimumUtilityFunction, "testAgent.MinimumUtilityFunction");
  	 +jmadem_utility_function(maximumUtilityFunction, "testAgent.MaximumUtilityFunction");
	 !jmadem_get_utility_function_names(UFNames);
	 .println("Registered utility functions for testAgent: ", UFNames);
	 PW = [jmadem_personal_weight(fernando,0.25),jmadem_personal_weight(miguel,0.5),jmadem_personal_weight(fran,0.75),jmadem_personal_weight(alejandro,0.5),jmadem_personal_weight(testAgent,0.5)];
     +jmadem_list_of_personal_weights(PW);
     UW = [jmadem_utility_weight(minimumUtilityFunction,0.25),jmadem_utility_weight(maximumUtilityFunction,0.75)];
     +jmadem_list_of_utility_weights(UW); 
 	 +jmadem_welfare(elitist);
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent), Allocations);
     !jmadem_launch_decision1([testAgent,fernando,miguel,fran,alejandro], Allocations, [maximumUtilityFunction,minimumUtilityFunction], DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_asl_launch_decision1 
  <- .println("Failed AgentSpeak test for jmadem.launch_decision1()").
+!test_asl_launch_decision 
  <- .println("Initiating AgentSpeak test for jmadem.launch_decision()");
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent), Allocations);
     !jmadem_launch_decision([fernando,miguel,alejandro], Allocations, [zeroUtilityFunction], DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_asl_launch_decision 
  <- .println("Failed AgentSpeak test for jmadem.launch_decision()").
+!test_asl_launch_decision_none
  <- .println("Initiating AgentSpeak test for jmadem.launch_decision() with none result");
     .println("This plan will fail on purpose. Do not panic!");
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent), Allocations);
     !jmadem_launch_decision([fernando,miguel,alejandro], Allocations, [noneUtilityFunction], DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_asl_launch_decision_none 
  <- .println("Failed AgentSpeak test for jmadem.launch_decision() with none result").
+!test_launch_decision1 
  <- .println("Initiating test for jmadem.launch_decision1()");
  	 jmadem.add_utility_function(minimumUtilityFunction, "testAgent.MinimumUtilityFunction");
  	 jmadem.add_utility_function(maximumUtilityFunction, "testAgent.MaximumUtilityFunction");
	 jmadem.get_utility_function_names(UFNames);
	 .println("Registered utility functions for testAgent: ", UFNames);
	 PW = [jmadem_personal_weight(fernando,0.25),jmadem_personal_weight(miguel,0.5),jmadem_personal_weight(fran,0.75),jmadem_personal_weight(alejandro,0.5),jmadem_personal_weight(testAgent,0.5)];
     jmadem.set_list_of_personal_weights(PW); 
     UW = [jmadem_utility_weight(minimumUtilityFunction,0.25),jmadem_utility_weight(maximumUtilityFunction,0.75)];
     jmadem.set_list_of_utility_weights(UW); 
 	 jmadem.set_welfare(elitist);
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent), Allocations);
     jmadem.launch_decision1([testAgent,fernando,miguel,fran,alejandro], Allocations, [maximumUtilityFunction,minimumUtilityFunction], DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_launch_decision1
  <- .println("Failed test for jmadem.launch_decision1()").
+!test_launch_decision 
  <- .println("Initiating test for jmadem.launch_decision()");
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent), Allocations);
     jmadem.launch_decision([fernando,miguel,alejandro], Allocations, [zeroUtilityFunction], DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_launch_decision 
  <- .println("Failed test for jmadem.launch_decision()").
+jmadem_result(DecisionId, Allocation)
  <- .println("MADeM Result for DecisionId ", DecisionId, " is ", Allocation);
	 .println("Successful test for jmadem.launch_decision()").

// Test for invoking MADeM specific decisions 
+!test_asl_launch_specific_decision1 
  <- .println("Initiating AgentSpeak test for jmadem.launch_specific_decision1()");
  	 +jmadem_utility_function(minimumUtilityFunction, "testAgent.MinimumUtilityFunction");
  	 +jmadem_utility_function(maximumUtilityFunction, "testAgent.MaximumUtilityFunction");
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent) & Agent \== testAgent, Allocations);
     !jmadem_launch_specific_decision1([fran, miguel, fernando,alejandro], Allocations, 
	 		 				  		   [maximumUtilityFunction,minimumUtilityFunction],
									   [jmadem_personal_weight(fernando,0.25),jmadem_personal_weight(miguel,0.5),jmadem_personal_weight(fran,0.75),jmadem_personal_weight(alejandro,0.5)],
									   [jmadem_utility_weight(minimumUtilityFunction,1),jmadem_utility_weight(maximumUtilityFunction,0.25)],
									   egalitarian, competitive, 1000, DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_asl_launch_specific_decision1 
  <- .println("Failed AgentSpeak test for jmadem.launch_specific_decision1()").
+!test_asl_launch_specific_decision 
  <- .println("Initiating AgentSpeak test for jmadem.launch_specific_decision()");
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent) & Agent \== testAgent, Allocations);
     !jmadem_launch_specific_decision([miguel, fernando,alejandro], Allocations, 
	 		 				  		  [zeroUtilityFunction],
									  [jmadem_personal_weight(fernando,0.25),jmadem_personal_weight(miguel,0.5),jmadem_personal_weight(alejandro,0.5)],
									  [jmadem_utility_weight(zeroUtilityFunction,1)],
									  egalitarian, competitive, 1000, DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_asl_launch_specific_decision 
  <- .println("Failed AgentSpeak test for jmadem.launch_specific_decision()").
+!test_launch_specific_decision1 
  <- .println("Initiating test for jmadem.launch_specific_decision1()");
  	 jmadem.add_utility_function(minimumUtilityFunction, "testAgent.MinimumUtilityFunction");
  	 jmadem.add_utility_function(maximumUtilityFunction, "testAgent.MaximumUtilityFunction");
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent) & Agent \== testAgent, Allocations);
     jmadem.launch_specific_decision1([fran, miguel, fernando,alejandro], Allocations, 
	 						  		  [maximumUtilityFunction,minimumUtilityFunction],
									  [jmadem_personal_weight(fernando,0.25),jmadem_personal_weight(miguel,0.5),jmadem_personal_weight(fran,0.75),jmadem_personal_weight(alejandro,0.5)],
									  [jmadem_utility_weight(minimumUtilityFunction,1),jmadem_utility_weight(maximumUtilityFunction,0.25)],
									  egalitarian, competitive, 1000, DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_launch_specific_decision1
  <- .println("Failed test for jmadem.launch_specific_decision1()").
+!test_launch_specific_decision 
  <- .println("Initiating test for jmadem.launch_specific_decision()");
     !jmadem_construct_allocations(use(coffeeMachine, Agent), ag(Agent) & Agent \== testAgent, Allocations);
     jmadem.launch_specific_decision([miguel, fernando,alejandro], Allocations, 
	 						  		 [zeroUtilityFunction],
									 [jmadem_personal_weight(fernando,0.25),jmadem_personal_weight(miguel,0.5),jmadem_personal_weight(alejandro,0.5)],
									 [jmadem_utility_weight(zeroUtilityFunction,1)],
									 egalitarian, competitive, 1000, DecisionId);
	 .println("Launched MADeM decision with identifier: ", DecisionId).
-!test_launch_specific_decision 
  <- .println("Failed test for jmadem.launch_specific_decision()").

