package testAgent;

import jmadem.*;
import jason.asSyntax.Term;

/** 
 * Test utility function always returning the highest normalized utility value (1),
 * regardless of the allocation being considered.
 *
 * @author Francisco Grimaldo
 */
public class MaximumUtilityFunction implements UtilityFunctionInt 
{
	/**
	  * Returns the highest normalized utility value for any allocation. 
	  *
	  * @param	auctioneer	agent asking for preference
	  * @param	alloc	allocation being evaluated
	  * 
	  * @throws	UtilityFunctionException when any error occurs
	  * @return	always 1, which will be the preference assigned to any allocation 
	  */
    public float computeUtility(String auctioneer, Term alloc, MADeMAgArch agArch) throws UtilityFunctionException
	{
		return 1;
	}
}

