package testAgent;

import jmadem.*;
import jason.asSyntax.Term;

/** 
 * Test utility function always returning the lowest normalized utility value (0),
 * regardless of the allocation being considered.
 *
 * @author Francisco Grimaldo
 */
public class MinimumUtilityFunction implements UtilityFunctionInt 
{
	/**
	  * Returns the lowest normalized utility value for any allocation. 
	  *
	  * @param	auctioneer	agent asking for preference
	  * @param	alloc	allocation being evaluated
	  * 
	  * @throws	UtilityFunctionException when any error occurs
	  * @return	always 0, which will be the preference assigned to any allocation 
	  */
    public float computeUtility(String auctioneer, Term alloc, MADeMAgArch agArch) throws UtilityFunctionException
	{
		return 0;
	}
}

