// Fernando agent

{ include("../../asl/jmadem.asl") }      // J-MADeM Plan Library 

/* Beliefs */

// minimumUtilityFunction: returns the utility value 0.2 if the allocation affects the agent.
//						   Otherwhise, it returns 1.
jmadem_utility(minimumUtilityFunction,_, Allocation, 0.2) :- .my_name(AgName) & Allocation = use(_,AgName).
jmadem_utility(minimumUtilityFunction,_, Allocation, 1)   :- .my_name(MyName) & Allocation = use(_,AgName) & MyName \== AgName.

// maximumUtilityFunction: returns the utility value 0.8 if the allocation affects the agent.
//                         Otherwhise, it returns 0.
jmadem_utility(maximumUtilityFunction,_, Allocation, 0.8) :- .my_name(AgName) & Allocation = use(_,AgName).
jmadem_utility(maximumUtilityFunction,_, Allocation, 0)   :- .my_name(MyName) & Allocation = use(_,AgName) & MyName \== AgName.

// zeroUtilityFunction: returns always 0.
jmadem_utility(zeroUtilityFunction,_,_,0).

// noneUtilityFunction: returns "none" in order to skip bidding and allow the MADeM
//                      to continue without the need to wait for the timeout.
jmadem_utility(noneUtilityFunction,_,_,none).

