// Fran agent

{ include("../../asl/jmadem.asl") }      // J-MADeM Plan Library 

/* Beliefs */

ag(fran).
ag(fernando).
ag(miguel).
ag(alejandro).

jmadem_welfare(utilitarian).

jmadem_utility_function(minimumUtilityFunction, "fran.MinimumUtilityFunction").
jmadem_utility_function(maximumUtilityFunction, "fran.MaximumUtilityFunction").

jmadem_personal_weight(fernando,0.25).
jmadem_personal_weight(miguel,0.5).
jmadem_personal_weight(alejandro,0.25).

jmadem_utility_weight(minimumUtilityFunction,0.25).
jmadem_utility_weight(maximumUtilityFunction,0.75).

/* Initial goal */

!test.

/* Test plans */

+!test
  <- .wait(100);
     .println("Initiating AgentSpeak test for launching J-MADeM decisions");
     TaskSlot = use(coffeeMachine, Agent);
	 Elements = (ag(Agent) & Agent \== fran);
     !jmadem_construct_allocations(TaskSlot, Elements, Allocs);
	 .findall(Ag, ag(Ag), Ags);
	 !jmadem_get_utility_function_names(Uts);
	 .println("Agents=", Ags);
	 .println("Allocations=", Allocs);
	 .println("UtilityFunctions=", Uts);
     jmadem.launch_decision(Ags, Allocs, Uts, DId);
	 .println("Launched MADeM decision with identifier: ", DId).

+jmadem_result(DecisionId, Allocation)
  <- .println("MADeM Result for DecisionId ", DecisionId, " is ", Allocation).
	 