package fran;

import jmadem.*;
import jason.asSyntax.*;

/** 
 * Test utility function always returning the utility value 0.7 if the allocation affects the agent.
 * Otherwhise, it returns 0.
 *
 * @author Francisco Grimaldo
 */
public class MaximumUtilityFunction implements UtilityFunctionInt 
{
	/**
	  * Test utility function always returning the utility value 0.7 if the allocation affects the agent. 
	  *
	  * @param	auctioneer	agent asking for preference
	  * @param	alloc	allocation being evaluated
	  * 
	  * @throws	utilityFunctionException when any error occurs
	  * @return	0.7 if the allocation affects the agent, 0 otherwise 
	  */
    public float computeUtility(String auctioneer, Term alloc, MADeMAgArch agArch) throws UtilityFunctionException
	{
		String ag = ((Literal) alloc).getTerms().get(1).toString();
		if( !ag.equals(agArch.getAgName()) ) 
			return 0;
		else
			return (float) 0.7;
	}
}

