// Miguel agent

{ include("../../asl/jmadem.asl") }      // J-MADeM Plan Library 

/* Plans */

// minimumUtilityFunction: returns the utility value 0.3 if the allocation affects the agent.
//                         Otherwhise, it returns 1.
+!jmadem_utility(minimumUtilityFunction, _, Allocation, 0.3) 
    : .my_name(AgName) & Allocation = use(_,AgName).
+!jmadem_utility(minimumUtilityFunction, _, Allocation, 1) 
    : .my_name(MyName) & Allocation = use(_,AgName) & MyName \== AgName.

// maximumUtilityFunction: returns the utility value 0.9 if the allocation affects the agent.
//                         Otherwhise, it returns 0.
+!jmadem_utility(maximumUtilityFunction, _, Allocation, 0.9) 
    : .my_name(AgName) & Allocation = use(_,AgName).
+!jmadem_utility(maximumUtilityFunction, _, Allocation, 0) 
    : .my_name(MyName) & Allocation = use(_,AgName) & MyName \== AgName.

// zeroUtilityFunction: returns always 0.
+!jmadem_utility(zeroUtilityFunction,_,_,0). 

// noneUtilityFunction: returns "none" in order to skip bidding and allow the MADeM
//                      to continue without the need to wait for the timeout.
+!jmadem_utility(noneUtilityFunction,_,_,none). 

