// Customer Agent

/* J-MADeM Plan Library */
{ include("../../../asl/jmadem.asl") } 

// Beliefs
// --------------
n_consumes(0).
n_friends_met(0).
dist2chair(0).
n_social_contacts(0).
consume_time(1000).
//consume_time(30000).
//consume_time(50000).


// Rules
// --------------
n_freeConsumePoints(N) :- .count(consumePointFree(_), N).


// Plans
// --------------

// Start and end (statistics)
+start 
   <- .send(customerGenerator, achieve, leave_bar(Name, 0));
	  +state(idle).
+endOfSimulation
   <- .abolish(state(_));
	  .drop_all_desires; 
      .drop_all_intentions;
	  ?n_social_contacts(NSocial);
	  ?n_consumes(NConsumes);
	  ?n_friends_met(NFriendsMet);
	  MeanNFriendsMet = NFriendsMet / NConsumes; 
	  ?dist2chair(Dist2Chair);
	  MeanDist2Chair = Dist2Chair / NConsumes; 
	  endOfSimulation(NSocial,MeanNFriendsMet, MeanDist2Chair).

// In state (idle)
+state(idle) : go_into_bar & .my_name(Name) & pos(Name, X, Y) & type(Name, Type)
   <- .abolish(go_into_bar);
   	  goIntoBar;
	  .print("<", system.time, ", ", Name, ", createAgent, customer,", Type, ",", X, ",", Y, ">");
      -+state(requestOrder).	
+state(idle) 
   <- .wait(2000);
	  -+state(idle).
	  
// In state (requestOrder)
+state(requestOrder)   
   <- !requestOrder;
	  -+state(selectConsumePoint).
// Enter into the bar and place an order   
+!requestOrder : .my_name(Name)
   <- !goToRequestPoint(Rpoint);
      generateOrders(1, Rpoint);
	  .print("<", system.time, ", ", Name, ",placeOrder>");
	  .concat("<", Name, ",placeOrder>", Message);
	  say(Message);
	  !waitUntilServed;
	  .abolish(served);
	  freeRequestPoint(Rpoint).
// Go to a free request point in the bar
+!goToRequestPoint(Rpoint) : not requestPointFree(_) 
   <- .wait(1000);
      !goToRequestPoint(Rpoint).
+!goToRequestPoint(Rpoint) : requestPointFree(Rp) 
   <- reserveRequestPoint(Rp);
      Rpoint = Rp;
      !go(Rp).
-!goToRequestPoint(Rpoint)
   <- .wait(1000);
      !goToRequestPoint(Rpoint).
// Waits until the order is served	  
+!waitUntilServed : served.
+!waitUntilServed
   <- .wait(1000);
	  !waitUntilServed.
	  
	  
// In state (selectConsumePoint)
+state(selectConsumePoint) :  sociability(Soc) & .random(N) & N < Soc & .my_name(Name)    
   <- -state(selectConsumePoint);
      +state(auction, whereToSit(Name), setWinnerPosition).
+state(selectConsumePoint)     
   <- //!randomConsumePoint(Cpoint);
      //!nearestConsumePoint(Cpoint);
	  Cpoint = bar;
      -state(selectConsumePoint);
      +state(consumeOrder, Cpoint).

+state(selectConsumePoint)     
   <- !jmadem_construct_allocations(sitAt(Pos), (Hour), Allocs);
      .findall(Name,customer(Name),LCustomers);
	  !jmadem_launch_decision(LCustomers, Allocs, [socialUF,lazyUF],_).

	  
	  
// In state (setWinnerPosition, whereToSit(_), LSortedWinnerPos)
+state(setWinnerPosition, whereToSit(_), LSortedWinnerPos)
   <- !selectConsumePoint(LSortedWinnerPos, Cpoint);
	  .abolish(state(setWinnerPosition,_,_));
	  +state(consumeOrder, Cpoint).
// Select a consume point from a list of tables
+!selectConsumePoint([], Cpoint)
   <- //!randomConsumePoint(Cpoint).
      !nearestConsumePoint(Cpoint).
  	  //Cpoint = bar.
+!selectConsumePoint([[U,Table]|LPairs], Cpoint)
   <- .findall(Pos,inTable(Table,Pos),Lpos);
      !selectPos(Lpos, Cpoint);
	   .ground(Cpoint);
	   ?pos(Cpoint,Xpoint,Ypoint);
	   .my_name(Name);
	   ?pos(Name,Xme,Yme);
       math.distance(Xpoint,Ypoint,Xme,Yme,DistX,DistY);	   
	   ?dist2chair(D);
	   -+dist2chair(D+DistX+DistY);
	   ?n_social_contacts(Ns);
	   -+n_social_contacts(Ns+1);
	   ?n_friends_met(N);
	   -+n_friends_met(N+U).
-!selectConsumePoint([_|LPairs], Cpoint)
   <- !selectConsumePoint(LPairs, Cpoint).
// Select a consume point from a list of pos
+!selectPos([],_).
+!selectPos([Pos|L],Cpoint) : consumePointFree(Pos)
   <- reserveConsumePoint(Pos);
      ?inTable(Table, Pos);
      +consumeInTable(Table);
      Cpoint = Pos.
-!selectPos([_|L], Cpoint)
   <- !selectPos(L, Cpoint).
+!selectPos([_|L],Cpoint)
   <- !selectPos(L, Cpoint).
// Randomly select a consume point	  
+!randomConsumePoint(Cpoint) : n_freeConsumePoints(0)
   <- .wait(1000);
      !randomConsumePoint(Cpoint).
+!randomConsumePoint(Cpoint) : n_freeConsumePoints(N) & N > 0 
   <- .findall(C,consumePointFree(C),LCp);
	  .length(LCp, Length);
	  Length > 0;
	  .random(X);
	  math.floor(X*(Length-1), I);
	  .nth(I,LCp,Cp);   
      reserveConsumePoint(Cp);
      ?inTable(Table, Cp);
      +consumeInTable(Table);
      Cpoint = Cp;
	  .findall(Chair,inTable(Table,Chair),LChairs);
	  !getNbFriends(LChairs, NFriends);
	  !test_social_contact(NFriends);
	  ?n_friends_met(Prev);
	  -+n_friends_met(Prev+NFriends).
-!randomConsumePoint(Cpoint)
   <- .wait(1000);
      !randomConsumePoint(Cpoint).
// Get the number of friends in a list of chairs
+!getNbFriends([], 0).
+!getNbFriends([Chair|L], N) : inConsumePoint(Chair, Ag) & type(Ag, T) & .my_name(MyName) & MyName \== Ag & type(MyName, T) 
   <- !getNbFriends(L, N2);
      N = N2 + 1.
+!getNbFriends([_|L], N) 
   <- !getNbFriends(L, N).

// Select the nearest consume point	  
+!nearestConsumePoint(Cpoint) : n_freeConsumePoints(0)
   <- .wait(1000);
      !nearestConsumePoint(Cpoint).
+!nearestConsumePoint(Cpoint) : n_freeConsumePoints(N) & N > 0 
   <- .findall(C,consumePointFree(C),LCp);
	  !getListOfCpsAndDistances(LCp, L);   
      math.sortListOfPairs(L, L2);
	  !selectPosDist(L2,Cp,Dist);
	  .ground(Cp);
	  ?dist2chair(D);
	  -+dist2chair(D+Dist); 
      ?inTable(Table, Cp);
      +consumeInTable(Table);
      Cpoint = Cp;
	  .findall(Chair,inTable(Table,Chair),LChairs);
	  !getNbFriends(LChairs, NFriends);
	  !test_social_contact(NFriends);
	  ?n_friends_met(Prev);
	  -+n_friends_met(Prev+NFriends).
-!nearestConsumePoint(Cpoint)
   <- .wait(1000);
      !nearestConsumePoint(Cpoint).

// Checks whether there are friends at table, thus, there is a social contact
+!test_social_contact(NFriends) : NFriends > 0
   <- ?n_social_contacts(Ns);
	  -+n_social_contacts(Ns+1).
+!test_social_contact(_).
	  
// Constructs a list of consume points with distances to them
+!getListOfCpsAndDistances([], []).   
+!getListOfCpsAndDistances([Cp|L], [[Dist,Cp]|L2])
   <- ?pos(Cp,Xpoint,Ypoint);
	  .my_name(Name);
	  ?pos(Name,Xme,Yme);
      math.distance(Xpoint,Ypoint,Xme,Yme,DistX,DistY);	   
      Dist = DistX + DistY;
      !getListOfCpsAndDistances(L,L2). 

// Select a consume point from a list of pos
+!selectPosDist([],_,_).
+!selectPosDist([[Dist,Pos]|L],Cpoint,D) : consumePointFree(Pos)
   <- reserveConsumePoint(Pos);
      ?inTable(Table, Pos);
      +consumeInTable(Table);
      Cpoint = Pos;
	  D = Dist.
-!selectPosDist([_|L], Cpoint, Dist)
   <- !selectPos(L, Cpoint).
+!selectPosDist([_|L],Cpoint, Dist)
   <- !selectPos(L, Cpoint, Dist).
	  
	  
// In state (consumeOrder)
+state(consumeOrder, Cpoint)   
   <- ?n_consumes(N);
	  -+n_consumes(N+1);
      !consumeOrder(Cpoint);
      .abolish(state(consumeOrder,_));
	  +state(leaveBar).
// Consume the order in the bar	  
+!consumeOrder(bar) : .my_name(Name)	  
   <- ?consume_time(T);   
	  .print("<", system.time, ", ", Name, ",consumeOrder,", T, ">");
      .wait(T). // !consumeOrder;
// Move to a chair and consume the order	  
+!consumeOrder(Cpoint) : .my_name(Name)	  
   <- !go(Cpoint);
      ?consume_time(T);   
	  .print("<", system.time, ", ", Name, ",consumeOrder,", T, ">");
      .wait(T);  // !consumeOrder;
	  freeConsumePoint(Cpoint);
	  .abolish(consumeInTable(_)).

// In state (leaveBar)
+state(leaveBar)   
   <- !leaveBar;
	  -+state(idle).
// Throw trash and leave the bar 
+!leaveBar : .my_name(Name)
   <- .findall(T,trashPoint(T),LTrash);
	  .nth(math.floor(math.random(.length(LTrash))),LTrash,Trash);   
	  !go(Trash);
	  .print("<", system.time, ", ", Name, ",throwTrash>");
	  throwTrash;
	  !go(exit);
	  .print("<", system.time, ", ", Name, ",deleteAgent>");
	  exitBar;
	  .send(customerGenerator, achieve, leave_bar(1)).
-!leaveBar : .my_name(Name)
   <- !go(exit);
	  .print("<", system.time, ", ", Name, ",deleteAgent>");
	  exitBar;
	  .send(customerGenerator, achieve, leave_bar(1)).

//  Move to a Location
+!go(L) : pos(L,X,Y) & .my_name(Name) & pos(Name,X,Y).
+!go(L) : pos(L,X,Y) & .my_name(Name) & pos(Name,Xme,Yme)
   <- moveTowards(X,Y);
      !go(L).	  
+!go(_).
	  
	  

