// Customer Generator Agent

// Beliefs
// --------------
requested_orders(0).
consumed_orders(0).

// Plans
// --------------

// Start and end plans
+start : nb_waiters(Nw) & nb_customers(Nc) 
   <- .print("<God,", createWorld,",", Nw, ",", Nc, ">");
      +state(idle).
+!endOfSimulation
   <- .abolish(state(_));
	  .drop_all_desires; 
      .drop_all_intentions;
	  endOfSimulation.

// In state (idle)
+state(idle) : consumed_orders(C) & nb_orders(C)
   <- !endOfSimulation.	
+state(idle): nb_orders(MaxO) & requested_orders(ReqO) & MaxO > ReqO
   <- -+state(generatingCustomer).
+state(idle) 
   <- .wait(3000);
	  -+state(idle).
	  
// In state (generatingCustomer)
+state(generatingCustomer)
   : order_freq(TimeMs) & TimeMs < 1000 & nb_orders(MaxO) & requested_orders(ReqO) 
   <- Num = math.min([math.floor(1000 / TimeMs), MaxO - ReqO]);
	  !generateCustomers(Num, NGenerated);
	  -+requested_orders(ReqO+NGenerated);
      .wait(1000);                 
      -+state(idle).
+state(generatingCustomer): order_freq(TimeMs) & requested_orders(O)
   <- !generateCustomers(1, NGenerated);
	  -+requested_orders(O+NGenerated);
      .wait(TimeMs);                 
      -+state(idle).

// Puts into the bar N customers that were outside 	  
+!generateCustomers(0, 0).
+!generateCustomers(1, 0) : not out(Ag).
+!generateCustomers(1, 1) : out(Ag)
   <- -out(Ag);
      .send(Ag, tell, go_into_bar).
+!generateCustomers(N, NGenerated) 
   <- !generateCustomers(1, NGenerated1);
      !generateCustomers(N-1, NGenerated2);
	  NGenerated = NGenerated1 + NGenerated2.

// A customer leaves the bar and a certain number of orders were consumed	  
+!leave_bar(NConsumedOrders) [source(Ag)] : consumed_orders(O)
   <- -+consumed_orders(O+NConsumedOrders);
	  +out(Ag).
	  
