// Waiter Agent
// --------------------

/* J-MADeM Plan Library */
{ include("../../../asl/jmadem.asl") } 

// General Beliefs
// ---------------

t_idle(0).
t_waiting(0).
t_use(0).
t_give(0).
t_comm(0).
n_wins(0).
t_chatting(0).
n_chats(0).
t_wait_chat(0).
id_action(0).
hands_busy(0).
//nb_waiters(0).
n_attend(0).
n_use(0).
n_give(0).

n_actions_tired(0).
max_actions_tired(10).

// Rules
// --------------
n_available_actions(N) :- .count(l_actions(_,_,_,init,_), N).
n_unattended_orders(N) :- .count(order(_,_,_,_), N).
n_uses(R, N) :- .count(using(R,_),N).


// Plans
// --------------

// Start and end (statistics)
+t_use(Resource,_) <- +n_orders(Resource,0).
+waiter(AgName) : .my_name(AgName) & personal_weight(W)
   <- jmadem.add_utility_function("waiter.Performance");
      jmadem.add_utility_function("waiter.Sociability");
   	  jmadem.add_utility_function("waiter.Tiredness");
      //?nb_waiters(N);
	  //-+nb_waiters(N+1);
      +favours(self, self, 1);
	  +w(self,W).
+waiter(AgName) : personal_weight(W)
   <- +friend(AgName);
      //?nb_waiters(N);
	  //-+nb_waiters(N+1);
      +favours(AgName, self, 1);
      +favours(self, AgName, 1);
	  +w(AgName,1-W).
+environment_sociability(Soc) : not sociability(_)
   <- +sociability(Soc).
+environment_talkative(Talk) : not talkative(_)
   <- +talkative(Talk).
+start :.my_name(Name)
   <- ?pos(Name, X, Y);
      .print("<", system.time, ", ", Name, ",createAgent,waiter,none,", X, ",", Y, ">");
      +state(idle).

// Get the balance in favours betweeen agents
+!getBalance(SumFselfi, SumFiself, Balance)
   <- .findall(Fselfi,favours(self,_,Fselfi),LFselfi);
	  !sumFavours(LFselfi, 0, SumFselfi);
      .findall(Fiself,favours(_,self,Fiself),LFiself);
	  !sumFavours(LFiself, 0, SumFiself);
      Balance = SumFselfi - SumFiself.
+!sumFavours([], SumF, SumF).
+!sumFavours([F|L], CurSum, SumF)
   <- !sumFavours(L, CurSum, Sum);
      SumF = Sum + F.
	  
// In state(idle)
+state(idle) : n_available_actions(N) & N \== 0
   <- -+state(selectAction).
+state(idle) : n_unattended_orders(N) & N \== 0
   <- -+state(pickOrder).
+state(idle) : finish_orders & .count(l_actions(_,_,_,_,_), 0)
   <- !decr_n_actions_tired;
      !wander;
      .wait(3000);
      -+state(idle).
+state(idle) : .my_name(Name)
   <- !decr_n_actions_tired;
      !wander;
      ?t_idle(T);
      -+t_idle(T + 3000);
      .print("<", system.time, ", ", Name, ",wait,3000>");
	  .wait(3000);
 	  -+state(idle).

// Increment-Decrement the number of actions without stop
+!decr_n_actions_tired : n_actions_tired(0).
+!decr_n_actions_tired : n_actions_tired(N)
   <- -+n_actions_tired(N-1).
+!incr_n_actions_tired : n_actions_tired(N)
   <- -+n_actions_tired(N+1).
	  
// Moves randomly a waiter
+!wander
   <- getWanderPosition;
      !go(wanderPosition);
	  ?pos(wanderPosition, X, Y);
	  delWanderPosition(pos(wanderPosition, X, Y)).
	  
// In state(pickOrder)
+state(pickOrder)
   <- !attendOrder;
	  -+state(selectAction).
+!attendOrder
   <- attend;
      !incr_n_actions_tired;
   	  ?n_attend(Nattend);
	  -+n_attend(Nattend+1);
      .my_name(MyName);
	  .findall(NumO,attending(MyName, order(NumO,_,_,_)),Lorders);
	  .max(Lorders,LastN);	  	  
	  ?attending(MyName, order(LastN, Cust, Rpoint, service(NumS, R)));
	  !go(Rpoint);
      .print("Atended: order(", LastN, ",", Cust, ",", Rpoint, ",service(", NumS, ",", R, "))");
      .print("<", system.time, ", ", MyName, ",attendOrder,", Cust, ",service(", NumS, ",", R, ")>");
	  .concat("<", MyName, ",attendOrder,", Cust, ",service(", NumS, ",", R, ")>", Message);
	  say(Message);
	  !add_l_actions(LastN, [use(R), give(R, Rpoint)], none, self).
-!attendOrder
   <- .print("Pick failure: No orders to attend").
// Adds a list of actions (avoids concurrency with !win)
@addLActions[atomic]
+!add_l_actions(NumO, LActions, AssignTo, Source)
   <- ?id_action(Id);
	  +l_actions(Id, NumO, LActions, init, AssignTo)[source(Source)];
	  -+id_action(Id + 1).

// In state(selectOrder)
+state(selectAction) : n_available_actions(N) & N == 0
   <- -+state(idle).
+state(selectAction)
   <- !nextAction(FirstId, Action);
      -state(selectAction);
      +state(startAction, FirstId, Action).
// Search the next available action
+!nextAction(FirstId, Action)
   <- .findall(Id,l_actions(Id,_,_,init,_),Lids);
   	  .min(Lids,FirstId);
	  ?l_actions(FirstId,_, LActions,_,_);
	  LActions = [Action|_].
-!nextAction(none, none).

// In state(startAction, Id)
+state(startAction, none, none) 
   <- .abolish(state(startAction,_,_));
      +state(idle).
+state(startAction, Id, Action) : l_actions(Id, NumO, LActions, init, none)
   <- -l_actions(Id, NumO, LActions, init, none);
      +l_actions(Id, NumO, LActions, bidding, none);
	  !nextAction(SecondId, ActionNext);
	  .time(HI, MI, SI);
	  +t_init(HI, MI, SI);
	  .my_name(AgName);
	  .findall(Ag, waiter(Ag), LWaiters);
	  jmadem.construct_allocations(execute_actions(Action,age,ActionNext,AgName), [age], [LWaiters], Alloc);
	  jmadem.launch_decision(LWaiters, Alloc, [tiredness], DecisionId);
	 
      -state(startAction, Id, Action);
      +state(auction, action(Id, Action, ActionNext), setWinner).
+state(startAction, Id, Action) : l_actions(Id, NumO, LActions, init, self)[source(Waiter)]
   <- -l_actions(Id, NumO, LActions, init, self)[source(Waiter)];
      +l_actions(Id, NumO, LActions, execute, self)[source(Waiter)];
	  .time(HI, MI, SI);
	  +t_init_action(Action, HI, MI, SI);
      -state(startAction, Id, Action); 
      +state(executeAction, Id, Action, init).
	  
// In state(setWinner, Auction, Winner, IsSocWinner, Friend)
+state(setWinner, action(Id,Action,_), self, IsSocWinner, Friend)
   <- .print("End auction winner self!");
      ?l_actions(Id, NumO, LActions, bidding, none);
      .abolish(l_actions(Id,_,_,_,_));
      +l_actions(Id, NumO, LActions, init, self);
	  .time(HF, MF, SF);
      ?t_init(HI, MI, SI);
	  Diff = ((SF+MF*60+HF*60*60) - (SI+MI*60+HI*60*60)) * 1000;
	  ?t_comm(T);
      -+t_comm(T + Diff);      
	  -t_init(HI, MI, SI);
      !animate(0, Action, IsSocWinner, Friend);
	  .abolish(state(setWinner,_,_,_,_));
      +state(startAction, Id, Action).
+state(setWinner, Auction, Winner, IsSocWinner, Friend)
   <- .print("End auction winner: ", Winner, " Passing action ", Auction, " SocWinner: ", IsSocWinner);
      Auction = action(Id,Action,_);
      ?l_actions(Id, NumO, LActions, bidding, none);
      .abolish(l_actions(Id,_,_,_,_));
      +l_actions(Id, NumO, LActions, execute, Winner);
      ?favours(Winner, self, F);
	  -favours(Winner, self, F);
	  +favours(Winner, self, F+1);
      .send(Winner, achieve, win(Auction));
	  .time(HF, MF, SF);
      ?t_init(HI, MI, SI);
	  Diff = ((SF+MF*60+HF*60*60) - (SI+MI*60+HI*60*60)) * 1000;
	  ?t_comm(T);
      -+t_comm(T + Diff);      
	  -t_init(HI, MI, SI);
      !animate(1, Action, IsSocWinner, Winner);
	  .abolish(state(setWinner,_,_,_,_));
	  +state(selectAction).
// Winner gets the result of the auction
+!win(action(IdE, Action,_))[source(Auctioneer)]
   <- ?favours(self, Auctioneer, F);
	  -favours(self, Auctioneer, F);
	  +favours(self, Auctioneer, F+1);
	  ?n_wins(N);
      -+n_wins(N + 1);
      !add_l_actions(IdE, [Action], self, Auctioneer).

	  
// Execution Model
// --------------

// In state(executeAction, Id, use(R))
+state(executeAction, Id, use(R), init) 
   <- .print("Start executing use(", R, ")");
      !approach(R);  //!go(R);
      .abolish(state(executeAction,_,_,_));
	  +state(executeAction, Id, use(R), queue);
      !queue(Id, R).
+!queue(Id, R)
   <- queue(R);
      .abolish(state(executeAction,_,_,_));
	  +state(executeAction, Id, use(R), use).
-!queue(Id, R) : l_actions(Id, NumO, LActions, execute, self)[source(self)]
   <- //.print("--> Resource not free. Trying to pass action again");
      .abolish(state(executeAction,_,_,_));
      .abolish(l_actions(Id,_,_,_,_));
      +l_actions(Id, NumO, LActions, bidding, none);
	  LActions = [Action|_];
	  !nextAction(SecondId, ActionNext);
  	  .time(HI, MI, SI);
	  +t_init(HI, MI, SI);
      +state(auction, action(Id, Action, ActionNext),setWinnerQueue).
+state(setWinnerQueue, action(Id, Action,_), self, IsSocWinner, Friend) : .my_name(Name)
   <- .print("End auction winner queue self!");
      ?l_actions(Id, NumO, LActions, bidding, none);
      .abolish(l_actions(Id,_,_,_,_));
      +l_actions(Id, NumO, LActions, execute, self);
	  .time(HF, MF, SF);
      ?t_init(HI, MI, SI);
	  Diff = ((SF+MF*60+HF*60*60) - (SI+MI*60+HI*60*60)) * 1000;
	  ?t_comm(TC);
      -+t_comm(TC + Diff);      
	  -t_init(HI, MI, SI);
	  .abolish(state(setWinnerQueue,_,_)); 
      !animate(0, Action, IsSocWinner, Friend);
      ?t_waiting(T);
      -+t_waiting(T + 1000);
	  .print("<", system.time, ", ", Name, ",wait,1000>");
	  .wait(1000);
      +state(executeAction, Id, Action, init).
+state(setWinnerQueue, Auction, Winner, IsSocWinner, Friend)
   <- .print("End auction winner queue: ", Winner, " Passing action ", Auction, " SocWinner: ", IsSocWinner);
      Auction = action(Id,use(R),_);
      unQueue(R);
      ?l_actions(Id, NumO, LActions, bidding, none);
      .abolish(l_actions(Id,_,_,_,_));
      +l_actions(Id, NumO, LActions, execute, Winner);
      ?favours(Winner, self, F);
	  -favours(Winner, self, F);
	  +favours(Winner, self, F+1);
      .send(Winner, achieve, win(Auction));
	  .time(HF, MF, SF);
      ?t_init(HI, MI, SI);
	  Diff = ((SF+MF*60+HF*60*60) - (SI+MI*60+HI*60*60)) * 1000;
	  ?t_comm(T);
      -+t_comm(T + Diff);      
	  -t_init(HI, MI, SI);
      !animate(1, use(R), IsSocWinner, Winner);
	  .abolish(t_init_action(_,_,_,_));
	  -state(setWinnerQueue, Auction, Winner);
	  +state(selectAction).
-!queue(Id, R) : .my_name(Name)
   <- //.print("--> Resource not free. Cannot doublepass an action = Wait! ");
      ?t_waiting(T);
      -+t_waiting(T + 1000);
	  .print("<", system.time, ", ", Name, ",wait,1000>");
	  .concat("+!queue(",Id,",",R,")", Event);
	  .at("now +1 s", Event).
+state(executeAction, Id, use(R), use)
   <- .time(HI, MI, SI);
	  +t_init(HI, MI, SI);
	  //?t_chatting(PrevT);
	  //+prev_t_chatting(PrevT);
      +using(R, Id);
	  !go(R);
      getService(1, R, Id);
   	  ?n_use(Nuses);
	  -+n_use(Nuses+1);
	  .concat("+!use(",Id,")", Event);
      .at("now +1 s", Event).
+!use(Id) : not state(executeAction, Id,_, use).
+!use(Id) : state(executeAction, Id, use(R), use) & n_uses(R,4) & .my_name(Name)
   <- //.print("--> Resource complete.");
      .print("<", system.time, ", ", Name, ",use,", R, ",1000>");
      !end_use;
	  .concat("+!use(",Id,")", Event);
      .at("now +1 s", Event).
+!use(Id) : state(executeAction, Id, use(R), use)  & .my_name(Name)
   <- .print("<", system.time, ", ", Name, ",use,", R, ",1000>");
      .findall(NewId,l_actions(NewId,_,[use(R)|_],init,_),Lids);
   	  .min(Lids,Id2);
	  ?l_actions(Id2, NumO, LActions, init, Ag)[source(Source)];
	  //.print("l_actions(",Id2,",", NumO,",", LActions,",", init,",", Ag, ")");
	  .abolish(l_actions(Id2,_,_,_,_));
	  +l_actions(Id2, NumO, LActions, execute, Ag)[source(Source)];
	  +using(R, Id2); 
	  getService(1, R, Id2);
      !incr_n_actions_tired;
   	  ?n_use(Nuses);
	  -+n_use(Nuses+1);
	  !end_use;
	  .concat("+!use(",Id,")", Event);
      .at("now +1 s", Event).
-!use(Id) : state(executeAction, Id, use(R), use) & .my_name(Name)
   <- //.print("--> No new_use to launch");
      .print("<", system.time, ", ", Name, ",use,", R, ",1000>");
	  !end_use;
	  .concat("+!use(",Id,")", Event);
      .at("now +1 s", Event).
+!end_use : finishUsing(R, Id) & l_actions(Id,_,LActions,_,_)[source(self)]
   <- finishUsing(R, Id);
	  !pop_action(Id);
	  -using(R, Id);
	  !check_end_using(R).
+!end_use : finishUsing(R, Id) & l_actions(Id,IdE,_,_,_)[source(Waiter)] & .my_name(Name)
   <- finishUsing(R, Id);
	  !pop_action(Id);
	  -using(R, Id);
	  .concat("<", Name, ",speech_act,shout,", Waiter, ",actionResult(", Action, ", finished)>", Message);
	  say(Message);
      .send(Waiter, tell, action_executed(IdE, use(R)));
	  !check_end_using(R).
+!end_use.
+!check_end_using(R) : n_uses(R, 0) 
   <- -+t_wait_chat(0);
      !wait_no_chat;
	  ?t_wait_chat(LostT);
      .time(HF, MF, SF);
      ?t_init(HI, MI, SI);
	  Diff = ((SF+MF*60+HF*60*60) - (SI+MI*60+HI*60*60)) * 1000;
	  //?t_chatting(CurT);
	  //?prev_t_chatting(PrevT);
	  //Diff2 = CurT - PrevT;
	  ?t_use(T);
      //-+t_use(T + Diff - Diff2);
	  -+t_use(T + Diff - LostT);      
	  -t_init(HI, MI, SI);
      //-prev_t_chatting(PrevT);
      .abolish(t_init_action(_,_,_,_));
      .abolish(state(executeAction,_,_,_));
      +state(selectAction).
+!check_end_using(R).	  
	  
// In state(executeAction, Id, give(R, Rpoint))
+state(executeAction, Id, give(R,Rpoint), init) :.my_name(Name)
   <- .print("Start executing give(", R, ",", Rpoint, ")");
      .time(HI, MI, SI);
	  //?t_chatting(PrevT);
	  -+t_wait_chat(0);
      -+hands_busy(1);
      !approach(R); //!go(R); 
      .print("<", system.time, ", ", Name, ",pickProduct,", R, ">");
	  !go_test; 
	  .time(HF, MF, SF);
	  Diff = ((SF+MF*60+HF*60*60) - (SI+MI*60+HI*60*60)) * 1000;
	  //?t_chatting(CurT);
	  //Diff2 = CurT - PrevT;
	  ?t_wait_chat(LostT);
	  ?t_give(T);
      //-+t_give(T + Diff - Diff2);
      -+t_give(T + Diff - LostT);      
	  .abolish(state(executeAction,_,_,_));
	  -+hands_busy(0);
	  .abolish(t_init_action(_,_,_,_));
	  -+state(selectAction).
+!go_test : state(executeAction, Id, give(R, Rpoint), init)    
   <- !go_give(Rpoint);
	  !give(Id).
-!go_test : state(executeAction, Id, give(R, Rpoint), init)
   <- !pick_other(Id2, Rpoint2);
      !go(Rpoint);
	  !give(Id);
      !go(Rpoint2);
	  !give(Id2).
+!pick_other(Id2, Rpoint2) :.my_name(Name)   
   <- .findall(Id,l_actions(Id,_,[give(_,_)|_],init,_),Lids);
   	  .min(Lids,Id2);
	  ?l_actions(Id2,_,[give(R,Rpoint2)|_], init,_)[source(_)];
	  -+hands_busy(2);
	  !approach(R); //!go(R);
	  .print("<", system.time, ", ", Name, ",pickProduct,", R, ">").
-!pick_other(none, none).
+!give(none).
+!give(Id) : l_actions(Id, NumO,_,_,_)[source(self)] 
   <- !pop_action(Id);
      .my_name(MyName);
	  ?attending(MyName, order(NumO, Cust, Rpoint, service(NumS, R)));
      give(MyName, order(NumO, Cust, Rpoint, service(NumS, R)));
	  .send(Cust, tell, served);
	  .print("<", system.time, ", ", MyName, ",give,", Cust, ">");
	  ?n_orders(R, N);
      -n_orders(R, N);
      +n_orders(R, N + 1);
      !incr_n_actions_tired;
	  ?n_give(Ngives);
	  -+n_give(Ngives+1).
+!give(Id) : l_actions(Id, IdE,_,_,_)[source(Waiter)] 
   <- !pop_action(Id);
      .send(Waiter, askOne, l_actions(IdE,X,_,_,_),A);
	  A = l_actions(IdE,NumO,_,_,_);
	  ?attending(Waiter, order(NumO, Cust, Rpoint, service(NumS, R)));
      give(Waiter, order(NumO, Cust, Rpoint, service(NumS, R)));
	  .send(Cust, tell, served);
      .my_name(MyName);
	  .print("<", system.time, ", ", MyName, ",give,", Cust, ">");
	  .send(Waiter, tell, action_executed(IdE, give(R, Rpoint)));
	  ?n_orders(R, N);
      -n_orders(R, N);
      +n_orders(R, N + 1);
      !incr_n_actions_tired;
	  ?n_give(Ngives);
	  -+n_give(Ngives+1).
-!give(Id)
   <- .print("--> Failure in give(", Id, ")").
   
// Waits until there is no chat  
+!wait_no_chat: not chatting.
+!wait_no_chat
   <- .wait(1000);
      ?t_wait_chat(T);
	  -+t_wait_chat(T + 1000);
	  !wait_no_chat.

//  Move to a Location (checks whether there is another give)
+!go_give(L) : chatting
   <- !wait_no_chat;
      !go_give(L).
+!go_give(L) : pos(L,X,Y) & .my_name(Name) & pos(Name,X,Y)
   <- .print("<", system.time, ", ", Name, ",moveTo,", X, ",", Y, ">").
+!go_give(L) : pos(L,X,Y) & .my_name(Name) & pos(Name,Xme,Yme)
   <- .print("<", system.time, ", ", Name, ",moveTo,", Xme, ",", Yme, ">");
      .findall(Id,l_actions(Id,_,[give(_,_)|_],init,_),[]);
      moveTowards(X,Y);
      !go_give(L).	   

//  Move to a Location
+!go(none).
+!go(L) : chatting
   <- !wait_no_chat;
      !go(L).
+!go(L) : pos(L,X,Y) & .my_name(Name) & pos(Name,X,Y).
//   <- .print("<", system.time, ", ", Name, ",moveTo,", X, ",", Y, ">").
+!go(L) : pos(L,X,Y) & .my_name(Name) & pos(Name,Xme,Yme)
   <- //.print("<", system.time, ", ", Name, ",moveTo,", Xme, ",", Yme, ">");
      moveTowards(X,Y);
      !go(L).	   
+!go(L)
   <- .print("--> Waiting in go for pos(", L, "_,_)");
      .wait(1000);
      !go(L).

// Get result for an allocated action	  
+action_executed(Id, Action)[source(Waiter)] : l_actions(Id,_,[Action|_],execute, Waiter)
   <- !pop_action(Id).
   
// Pops the first action. Deletes l_actions when there is one single action
+!pop_action(Id) : l_actions(Id,_,[_|[]],_,_)
   <- .abolish(l_actions(Id,_,_,_,_)).
+!pop_action(Id) : l_actions(Id,NumO,[_|L],_,_)
   <- .abolish(l_actions(Id,_,_,_,_));
      +l_actions(Id, NumO, L, init, none).	   
		   

// Social actions
// --------------

// In animate(Situation, AuctionedAction, IsSocWinner, Friend)
// When Winner=self -> Situation = 0
+!animate(0, Action, no,_) : (Action = use(R) | Action = give(R,_)) 
   <- !getRandomNearAgent(R, Ag); 
      !actionRequest(shout, Ag, Action, no).
+!animate(0,_, yes, Friend)
   <- !plan_meeting(yes, Friend).

// Plan a meeting with a friend
+!plan_meeting(_,self).
+!plan_meeting(yes, Friend)	  
   <- +planned_meeting(Friend);
      .abolish(near(Friend)).

// Randomly gets a friend that is near to a resource
+!getRandomNearAgent(R, Ag)
   <- .findall(Name,friend(Name),LFriends);
      !filterNearAgents(R, LFriends, [], LFiltered);
	  !getRandomFromList(Lfiltered, Ag).
+!getRandomFromList([], none).
+!getRandomFromList(L, Ag)
   <- .length(L, Length);
	  .random(X);
	  math.floor(X*(Length-1), I);
	  .nth(I,LFiltered,Ag).
+!filterNearAgents(_, [], LFiltered, LFiltered).
+!filterNearAgents(R, [Name|L], LPrev, LFiltered)
   <- !addNearAgent(R, Name, LPrev, LAux);
      !filterNearAgents(R, L, LAux, LFiltered).
+!addNearAgent(R, Name, LPrev, [Name|LPrev]) : pos(R, Xr, Yr) & pos(Name, Xag, Yag) & near_dist(Near) 
 											 & DistX = Xr - Xag & DistY = Yr - Yag 
											 & DistX > -Near & DistX < Near 
											 & DistY > -Near & DistY < Near.
//<- math.distance(Xr, Yr, Xag, Yag, DistX, DistY);
//	  DistX < Near;
//	  DistY < Near.   
//-!addNearAgent(_,_, LPrev, LPrev). 
+!addNearAgent(_,_, LPrev, LPrev).

// Requests an action to be performed (answer is also provided)
+!actionRequest(_,none,_,_).
+!actionRequest(Type, Ag, Action, Response) : .my_name(Name)
   <- //?pos(Ag, X, Y);
      X = 0; Y = 0;
      .print("<", system.time, ", ", Name, ",speech_act,", Type, ",", Ag, ",", X, ",", Y, ",actionRequest(", Action, ")>");
	  .concat("<", Name, ",speech_act,", Type, ",", Ag, ",", X, ",", Y, ",actionRequest(", Action, ")>", Message);
	  say(Message);
      .send(Ag, achieve, actionRequest(Type, Action, Response));
      +waitingActionRequest(Type, Ag, Action, Response);
      !waitActionRequestResponse(Type, Ag, Action, Response).
+!waitActionRequestResponse(Type, Ag, Action, Response) : waitingActionRequest(Type, Ag, Action, Response)  
   <- ?t_comm(T);
      -+t_comm(T + 1000);
	  .wait(1000);
	  !waitActionRequestResponse(Type, Ag, Action, Response).
+!waitActionRequestResponse(_,_,_,_).
+!actionRequest(Type, Action, Response)[source(Origin)] : .my_name(Name)
   <- //?pos(Origin, X, Y);
      X = 0; Y = 0;
      .print("<", system.time, ", ", Name, ",speech_act,", Type, ",", Origin, ",", X, ",", Y, ",actionResponse(", Action, ",", Response, ")>");
	  .concat("<", Name, ",speech_act,", Type, ",", Origin, ",", X, ",", Y, ",actionResponse(", Action, ",", Response, ")>", Message);
	  say(Message);
      .send(Origin, achieve, actionRequestResponse(Type, Action, Response)).
+!actionRequestResponse(Type, Action, Response)[source(Origin)]
   <- -waitingActionRequest(Type, Origin, Action, Response).

// In animate(Situation, AuctionedAction, IsSocWinner, Friend)
// When Winner!=self -> Situation = 1
+!animate(1, Action, no, Friend) : noise(N) & threshold(T) & N < T
   <- !actionRequest(shout, Friend, Action, yes).
+!animate(1, Action, no, Friend)
   <- !approach(Friend);
      !actionRequest(tell, Friend, Action, yes).
+!animate(1, Action, yes, Friend) : noise(N) & threshold(T) & N < T
   <- !actionRequest(shout, Friend, Action, yes);
      !plan_meeting(yes,Friend).
+!animate(1, Action, yes, Friend)
   <- !approach(Friend);
      !actionRequest(tell, Friend, Action, yes);
	  !plan_meeting(yes,Friend).
//  Approach to a Location
+!approach(L) : chatting
   <- !wait_no_chat;
      !approach(L).
+!approach(L) : pos(L,Xl,Yl) & .my_name(Name) & pos(Name,Xme,Yme) & near_dist(Near)
              & DistX = Xl - Xme & DistY = Yl - Yme 
			  & DistX > -Near & DistX < Near & DistY > -Near & DistY < Near.  
//   <- math.distance(Xl, Yl, Xme, Yme, DistX, DistY);
//	  DistX < Near;
//	  DistY < Near.
//-!approach(L) //: .my_name(Name) & (not pos(L,Xl,Yl) | not pos(Name,Xme,Yme)) 
//   <- .wait(1000);
//      !approach(L).
+!approach(L) : pos(L,X,Y) & .my_name(Name) &  pos(Name,Xme,Yme)
   <- .print("<", system.time, ", ", Name, ",moveTo,", Xme, ",", Yme, ">");  
      moveTowards(X,Y);
      !approach(L).	   
+!approach(L) //: .my_name(Name) & (not pos(L,Xl,Yl) | not pos(Name,Xme,Yme)) 
   <- .wait(1000);
      !approach(L).
   
// Chat with a friend
+near(Ag) : planned_meeting(Ag) & talkative(Talk) & .random(N) & N < Talk
   <- !chat(Ag);
      .abolish(planned_meeting(Ag)).
+near(Ag) : planned_meeting(Ag)
   <- .abolish(planned_meeting(Ag)).
//+near(Ag) : pos(wanderPosition,_,_) & talkative(Talk) & .random(N) & N < Talk
//   <- !chat(Ag).
   
+!chat(Ag)  
   <- .my_name(Name);
	  !getTChat(TChat);
	  ?pos(Ag, X, Y);
      .print("<", system.time, ", ", Name, ",speech_act,", Ag, ",", X, ",", Y, ",chat(", TChat, ")>");
	  .concat("<", Name, ",speech_act,", Ag, ",", X, ",", Y, ",chat(", TChat, ")>", Message);
	  say(Message);
      .send(Ag, achieve, chat(Name, TChat));
      ?t_chatting(T);
      -+t_chatting(T + TChat);
	  ?n_chats(N);
	  -+n_chats(N+1);
	  +chatting;
	  .wait(TChat);
	  -chatting.
+!chat(Friend, TChat)[source(Friend)] : .my_name(Name) 
   <- ?pos(Friend, X, Y);
      .print("<", system.time, ", ", Name, ",speech_act,", Friend, ",", X, ",", Y, ",chat(", TChat, ")>");
	  .concat("<", Name, ",speech_act,", Friend, ",", X, ",", Y, ",chat(", TChat, ")>", Message);
	  say(Message);
      ?t_chatting(T);
      -+t_chatting(T + TChat);
	  ?n_chats(N);
	  -+n_chats(N+1);
	  +chatting;
	  .wait(TChat);
	  -chatting.
	  
// Types of conversations	  
+!getTChat(3000) : pos(wanderPosition,_,_).
+!getTChat(3000) : state(executeAction,_,use(_),_).
+!getTChat(1000) : state(executeAction,_,give(_,_),_).
+!getTChat(500).

	  
