package bar;

import jason.environment.grid.GridWorldView;

import java.awt.Color;
import java.awt.Graphics;

import java.util.logging.Logger;


public class WorldView extends GridWorldView {

	// singleton pattern
    private static WorldView view      = null;

    private Logger            logger   = Logger.getLogger("bar.mas2j." + WorldView.class.getName());

    synchronized public static WorldView create(WorldModel model) {
        if (view == null) {
            view = new WorldView(model);
        }
        return view;
    }

    private WorldView(WorldModel model) {
        super(model, "Bar World", 500);
        setVisible(true);
        repaint();
    }

	public static void destroy() {
        if (view != null) {
            view.setVisible(false);
            view = null;
        }
    }
	
    @Override
    public void draw(Graphics g, int x, int y, int object) {
        switch (object) {
        case WorldModel.COFFEE_MACHINE:   drawBarObject(g, x, y, "Cm");  break;
        case WorldModel.JUICE_MACHINE:    drawBarObject(g, x, y, "Jm");  break;
        case WorldModel.GRILL:            drawBarObject(g, x, y, "Gr");  break;
        case WorldModel.PASTRIES:         drawBarObject(g, x, y, "Pa");  break;
        case WorldModel.COCKTAILS:        drawBarObject(g, x, y, "Ck"); break;
        case WorldModel.SNACKS:           drawBarObject(g, x, y, "Sn");  break;
        case WorldModel.TRASH:            drawBarObject(g, x, y, "Tr");  break;
        case WorldModel.BAR:              drawBarObject(g, x, y, "Ba");  break;
        case WorldModel.ENTRANCE:         drawBarObject(g, x, y, "En");  break;
        case WorldModel.EXIT:             drawBarObject(g, x, y, "Ex");  break;
        case WorldModel.TABLE:            drawBarObject(g, x, y, "Ta");  break;
		default:              
		    logger.info("No graphic match!");
        }
    }

    public void drawBarObject(Graphics g, int x, int y, String l) {
        super.drawObstacle(g, x, y);
        g.setColor(Color.white);
        drawString(g, x, y, defaultFont, l);
    }

	@Override
    public void drawAgent(Graphics g, int x, int y, Color c, int id) {
        if (id < ((WorldModel)model).getNbCustomers()) 
		{
			if (((WorldModel)model).isIntoBar(id))
			{
				switch (((WorldModel)model).getTypeOfCustomer(id))
				{
					case 0:	 c = Color.blue; break;
					case 1:	 c = Color.red; break;
					case 2:	 c = Color.green; break;
					default: c = Color.black; break;
				}
				super.drawAgent(g, x, y, c, -1);
				g.setColor(Color.white);
				super.drawString(g, x, y, defaultFont, "C" + (id+1));
			}
		}
	    else
		{
            c = Color.yellow;
            super.drawAgent(g, x, y, c, -1);
            g.setColor(Color.black);
			super.drawString(g, x, y, defaultFont, "W" + (id+1-((WorldModel)model).getNbCustomers()));
		}
    }

}
