package customer;

import jason.asSemantics.*;
import jason.asSyntax.*;

import java.util.*;

import jmadem.MADeMAgArch;

public class CustomerAgArch extends MADeMAgArch {

	/** Agent act function */
	public void act(ActionExec action, List<ActionExec> feedback) 
	{
		// get the action to be performed
        Structure taction = action.getActionTerm();
		if (taction.getFunctor().equals("getUtility"))
		{
			Literal auction = Literal.parseLiteral(taction.getTerm(0).toString());
			String auctioneer = taction.getTerm(1).toString();
			double utility = 0;
			Unifier un = new Unifier();
			Literal l, res, res2;
			String table = "none";
			
			// Performance utility
			if (auction.getFunctor().equals("whereToSit"))
			{
				l = Literal.parseLiteral("consumeInTable(_)");
				res2 = getTS().getAg().findBel(l, un);
				if (res2 != null)
				{
					String agName = getAgName();
					l = Literal.parseLiteral("type(" + agName + ",_)");
					res = getTS().getAg().findBel(l, un);
					String tipo1 = res.getTerm(1).toString();
					l = Literal.parseLiteral("type(" + auctioneer + ",_)");
					res = getTS().getAg().findBel(l, un);
					String tipo2 = res.getTerm(1).toString();
					if (tipo1.equals(tipo2))  // Friends = Same time of agents
					{
						utility = 1;
						table = res2.getTerm(0).toString();
					}
				}					
			}
			else
				System.out.println("--> Unable to get utility: Unknown action " + auction.getFunctor());
			
			
			try
			{
				getTS().getAg().addBel(Literal.parseLiteral("utility(" + taction.getTerm(0).toString() + 
			     	                  "," + utility + "," + table + ")"));
			}
			catch (jason.RevisionFailedException e)
			{
				e.printStackTrace();
			}
			
			action.setResult(true);
			feedback.add(action);
		}
		else
            super.act(action,feedback);
	}

}
