package traffic;

import java.util.ArrayList;

/** 
 * class Group
 *
 * @author Fco. Javier Cordero Cadenas
 */

public class Group {

	private int groupId; 													//group identifier
	private ArrayList<Habitant> habitantGroup = new ArrayList<Habitant>();	//list of habitants that belongs to a group
	
	/**
	 * constructors
	 */
	public Group(){}
	
	public Group(int id){
		groupId = id;
	}
	
	/**
	 * setters and getters
	 */
	public void setGroupId(int id){
		groupId = id;
	}
	
	public int getGroupId(){
		return groupId;
	}

	public ArrayList<Habitant> getHabitants(){
		return habitantGroup;
	}
	
	/**
	 * add an habitant to the group
	 *
	 * @param h	the habitant to adding to the group
	 */
	public void addHabitant(Habitant h){
		if (!habitantGroup.contains(h)){
			habitantGroup.add(h);
		}
	}
	
	/**
	 * show the group information
	 */
	public void show(){
        System.out.print("-- GROUP -- ID:"+groupId+" MEMBERS: { ");
		for (Habitant h:habitantGroup){
			System.out.print(h.getHabitantName()+" ");
		}
		System.out.println("}");
    }
}
