package traffic;
 
import java.util.ArrayList;

/** 
 * class Habitant
 *
 * @author Fco. Javier Cordero Cadenas, Francisco Grimaldo
 */

public class Habitant {

	private ArrayList<Vehicle> vehicleList = new ArrayList<Vehicle>();	//list of the vehicles belongs to the habitant
	private int habitantId;												//habitant identifier
	private String habitantName;										//habitant name
	private int villageId;												//village identifier where habitant lives
	private int habitantPosX;											//position in X coordinates of the habitant
	private int habitantPosY;											//position in Y coordinates of the habitant
	private int habitantSalary;											//salary of the habitant
	private int habitantCapital;										//capital that habitant has got
	private String habitantStartAt;										//time of entering to the work
	
	/**
	 * constructors
	 */
	public Habitant (){}
	
	public Habitant (int id, String name, int vId, int posX, int posY, String startAt, int salary) {
		habitantId = id;
		habitantName = name;
		villageId = vId;
		habitantPosX = posX;
		habitantPosY = posY;
		habitantStartAt = startAt;
		habitantSalary = salary;
		habitantCapital = salary;
	}
	
	/**
	 * setters and getters
	 */
	public void setVillageId(int id){
		villageId = id;
	}

	public void setHabitantName(String name){
		habitantName = name;
	}
	
	public void setHabitantPosX(int posX){
		habitantPosX = posX;
	}
	
	public void setHabitantPosY(int posY){
		habitantPosY = posY;
	}
	
	public void setHabitantStartAt(String startAt){
		habitantStartAt = startAt;
	}
	
	public void setHabitantCapital(int capital){
		habitantCapital = capital;
	}
	
	public void addVehicle(Vehicle veh){
		if (!vehicleList.contains(veh)){
			vehicleList.add(veh);
			veh.setVehicleOwnerId(getHabitantId() );
		}
	}
	
	public int getHabitantId(){
		return habitantId;
	}
	
	public String getHabitantName(){
		return habitantName;
	}
	
	public int getVillageId(){
		return villageId;
	}
	
	public int getHabitantPosX(){
		return habitantPosX;
	}
	
	public int getHabitantPosY(){
		return habitantPosY;
	}
	
	public String getHabitantStartAt(){
		return habitantStartAt;
	}
	
	public int getHabitantSalary(){
		return habitantSalary;
	}

	public int getHabitantCapital(){
		return habitantCapital;
	}
	
	public ArrayList<Vehicle> getVehicleList(){
		return vehicleList;
	}
	
	public Vehicle getVehicle(String id){
        for(Vehicle v: vehicleList){
            if (v.getVehicleId().equals(id)){
				return (v);
			}
        }
		return null;
	}
	
	/**
	 * show the habitant information
	 */
	public void show(){
        System.out.println ("-- Habitant -- ID:"+habitantId+" NAME:"+habitantName+" POSITION("+habitantPosX+","
		+habitantPosY+") START_AT:"+habitantStartAt+" CAPITAL:"+habitantCapital);
    }

	/**
	 * show the vehicle list information
	 */
	public void showVehicleList(){
        for(Vehicle v: vehicleList)
            v.show();
    }
}
