package traffic;

/**
 * class SimulationElement
 *
 * @author Fco Javier Cordero Cadenas
 */

public class SimulationElement implements Comparable<SimulationElement>{
	
	private Vehicle vehicle;			//vehicle
	private Float exitTime;				//time to begin the travel
	private Float enterRoadTime;		//time to enter the road, it will differ from exitTime when getting partners
	private Float enterRoadKm;			//Km to enter the road. Destination is Km 0.
	private Float calculatedTime;		//real time the travel costs
	private Float atWork;				//time of entering to the work
	private Float consumption;			//calulated consumption of gas of the travel
	private Float estimatedConsumption;	//estimated consumption of gas of the travel
	
	/**
	 * constructors
	 */
	public SimulationElement(){
	}
	
	public SimulationElement(Vehicle v, Float et, Float km, Float aw, Float cons){
		vehicle = v;
		exitTime = et;
		enterRoadTime = exitTime;
		enterRoadKm = km;
		atWork = aw;
		consumption = 0f;
		estimatedConsumption = cons;
	}
	
	/**
	 * setters and getters
	 */
	public void setVehicle(Vehicle v){
		vehicle = v;
	}
	
	public void setEnterRoadTime(Float er){
		enterRoadTime = er;
	}
	
	public void setExitTime(Float et){
		exitTime = et;
	}

	public void setCalculatedTime(Float ct){
		calculatedTime = ct;
	}
	
	public void setAtWork(Float a){ 
		atWork = a;
	}
	
	public void setConsumption(Float c){
		consumption = c;
	}
	
	public void setEstimatedConsumption(Float e){
		estimatedConsumption = e;
	}
	
	public Vehicle getVehicle(){
		return vehicle;
	}
	
	public Float getExitTime(){
		return exitTime;
	}
	
	public Float getEnterRoadTime(){
		return enterRoadTime;
	}

	public Float getEnterRoadKm(){
		return enterRoadKm;
	}

	public Float getCalculatedTime(){
		return calculatedTime;
	}
	
	public Float getAtWork(){
		return atWork;
	}
	
	public Float getConsumption(){
		return consumption;
	}
	
	public Float getEstimatedConsumption(){
		return estimatedConsumption;
	}
	
	/**
	 * get if a pair of simulation elements are equals
	 * 
	 * @param sim	SimulationElement to compare
	 *
	 * @return 1 whether the both simulation elements are equals, 0 if aren't equals
	 */
	public int compareTo(SimulationElement sim) {
        return calculatedTime.compareTo(sim.getCalculatedTime());
    }
}
