package traffic;

/* 
   An object of class StatCalc can be used to compute several simple statistics
   for a set of numbers.  Numbers are entered into the dataset using
   the enter(double) method.  Methods are provided to return the following
   statistics for the set of numbers that have been entered: The number
   of items, the sum of the items, the maximum, the average, and the standard deviation.
*/

public class StatCalc {

   private int count;         						// Number of numbers that have been entered.
   private double sum;        						// The sum of all the items that have been entered.
   private double squareSum;  						// The sum of the squares of all the items.

   private double max = Double.NEGATIVE_INFINITY;   // Max number that have been entered
   private double min = Double.POSITIVE_INFINITY;	// Min number that have been entered
   
   /**
    * add a number to the dataset.
	*
	* @param num	the number to adding to the dataset
	*/
   public void enter(double num) {
		  
      count++;
      sum += num;
      squareSum += num*num;
	  
	  if (num > max)
	      max = num;
	  
	  if (num < min)
		  min = num;
   }

   /**
    * return number of items that have been entered
	*/
   public int getCount() {
      return count;
   }

   /**
    * return the summation of all the items that have been entered
	*/
   public double getSum() {
      return sum;
   }

   /**
    * return the maximum of all the items that have been entered
	*/
   public double getMax() {
      return max;
   }
   
   /**
    * return the minimum of all the items that have been entered
	*/
   public double getMin(){
	  return min;
   }

   /**
    * return the average of all the items that have been entered
	* value is Double.NaN if count == 0.
	*/
   public double getMean(){
      return sum / count;  
   }

   /**
    * return the standard deviation of all the items that have been entered
	* value is Double.NaN if count == 0.
	*/
   public double getStandardDeviation(){ 
      double mean = getMean();
      return Math.sqrt( squareSum/count - mean*mean );
   }

}