package traffic;

import java.util.TreeMap;

/**
 * class Vehicle
 *
 * @author Fco Javier Cordero Cadenas
 */
 
public class Vehicle {

	private String vehicleId;													//Vehicle identifier
	//private String vehicleType;													//Type of vehicle (car, bus, train, bike, moto)
	private VehicleType vehicleType;													//Type of vehicle (car, bus, train, bike, moto)
	private int vehicleSeats;													//Squares of the vehicle
	private float vehicleMaxVel;												//Maximum speed that the vehicle could reach
	private int vehicleOwnerId;													//Identifier of the vehicle owner
	private TreeMap<Integer,Float> consumption = new TreeMap<Integer,Float>();	//Consumptions of the vehicle concerning the speed
	private float consumptionStop;												//Consumption when the vehicle is stopped
	private float provConsumption;												//Consumption of the vehicle
	
	/**
	 * constructors
	 */
	public Vehicle(){}
	
	public Vehicle(String id, VehicleType type, int seats, float maxVel, int ownerId){
		vehicleId = id;
		vehicleType = type;
		vehicleSeats = seats;
		vehicleMaxVel = maxVel;
		vehicleOwnerId = ownerId;
	}
	
	/**
	 * setters and getters
	 */
	
	public void setVehicleMaxVel(float maxVel){
		vehicleMaxVel = maxVel;
	}
	
	public void setVehicleOwnerId(int ownerId){
		vehicleOwnerId = ownerId;
	}
	
	public void setConsumptionStop(float cons){
		consumptionStop = cons;
	}
	
	public void setConsumption(float cons){
		provConsumption = cons;
	}
	
	public String getVehicleId(){
		return vehicleId;
	}
	
	public VehicleType getVehicleType(){
		return vehicleType;
	}
	
	public int getVehicleSeats(){
		return vehicleSeats;
	}
	
	public float getVehicleMaxVel(){
		return vehicleMaxVel;
	}
	
	public int getVehicleOwnerId(){
		return vehicleOwnerId;
	}
	
	public float getConsumptionStop(){
		return consumptionStop;
	}
	
	public float getConsumption(){
		return provConsumption;
	}
	
	/**
	 * add a consumption corresponding to an speed
	 */
	public void addConsumption(int vel,float cons){
		consumption.put(vel,cons);
	}
	
	/**
	 * get the vehicle consumption when it circulate to certain speed
	 *
	 * @param vel	Speed of the vehicle
	 *
	 * @return consumption whether it exists, otherwise return 0
	 */
	public float getConsumption(int vel){
		if (consumption.containsKey(vel)){
			return consumption.get(vel);
		} else{
			Integer hKey,lKey;
			hKey = consumption.higherKey(vel);
			lKey = consumption.lowerKey(vel);	
			if (hKey != null && lKey != null){
				return (consumption.get(lKey)+consumption.get(hKey))/2;
			} else if (hKey != null && lKey == null){
				return (consumption.get(hKey));
			} else if (hKey == null && lKey != null){
				return (consumption.get(lKey));
			} else{
				return 0;
			}
		}
	}
	
	/**
	 * show the vehicle information
	 */
	public void show(){
        System.out.println ("-- Vehicle -- ID:"+vehicleId+" TYPE:"+vehicleType+" SEATS:"+vehicleSeats+" MAX_VEL:"+vehicleMaxVel+" OWNER_ID:"+vehicleOwnerId);
    }
}
