package traffic;

import java.util.ArrayList;

/** 
 * class Village
 *
 * @author Fco. Javier Cordero Cadenas
 */

public class Village {
	private ArrayList<Habitant> habitantList = new ArrayList<Habitant>();	//List of the village habitants
	private ArrayList<Vehicle> vehicleList = new ArrayList<Vehicle>(); 		//List of all vehicles
	private ArrayList<Vehicle> cityVehicleList = new ArrayList<Vehicle>(); 	//List of city vehicles (train, buses, ...)
	private ArrayList<Group> habitantGroups = new ArrayList<Group>(); 		//List of groups of habitants
	private Road road; 														//Road that communicates the town with the city
	private Float enterRoadKm;												//At what Km of the road is located the village 
	private int villageId;													//Village identifier
	private String villageName;												//Village name
	private int villageNumHabs;												//Number of habitants of the village
	private int villageScale;												//Scale respect the real number of habitants of village
	private int villagePosX; 												//Position in the coordinates X of the village
	private int villagePosY; 												//Position in the coordinates X of the village
	private int villageWidth;												//Width of the village
	private int villageHeight;												//Height of the village
	private int percentLow;													//Percentage of population of low class
	private int percentMiddle;												//Percentage of population of middle class
	private int percentHigh;												//Percentage of population of high class
	private int salaryLow;													//Salary of the low class
	private int salaryMiddle;												//Salary of the middle class
	private int salaryHigh;													//Salary of the high class
	private boolean hasBus;													//Indicate if the village has bus
	private boolean hasTrain;												//Indicate if the village has train
	
	/**
	 * constructor
	 */
	public Village(){}	
		
	/**
	 * setters ang getters
	 */
    public void setVillageId(int id){
        villageId = id;
    }

    public void setVillageName(String name){
        villageName = name;
    }
    
    public void setVillageNumHabs(int numHabs){
        villageNumHabs = numHabs;
    }    
    
    public void setVillageScale(int scale){
        villageScale = scale;
    }
    
    public void setVillagePosX(int x){
        villagePosX = x;
    }
    
    public void setVillagePosY(int y){
        villagePosY = y;
    }
	
	public void setVillageWidth(int width){
		villageWidth = width;
    }
	
	public void setVillageHeight(int height){
		villageHeight = height;
    }
	
	public void setPercentLow(int low){
		percentLow = low;
    }
	
	public void setPercentMiddle(int middle){
		percentMiddle = middle;
    }
	
	public void setPercentHigh(int high){
		percentHigh = high;
    }
	
	public void setSalaryLow(int low){
		salaryLow = low;
    }
	
	public void setSalaryMiddle(int middle){
		salaryMiddle = middle;
    }
	
	public void setSalaryHigh(int high){
		salaryHigh = high;
    }

	public void setHasBus(boolean bus){
		hasBus = bus;
	}
	
	public void setHasTrain(boolean train){
		hasTrain = train;
	}
	
	public void setRoad(Road r){
		road = r;
	}
	
	public void setEnterRoadKm(Float km){
		enterRoadKm = km;
	}
	
    public int getVillageId(){
        return villageId;
    }

    public String getVillageName(){
        return villageName;
    }
    
    public int getVillageNumHabs(){
        return villageNumHabs;
    }    
    
    public int getVillageScale(){
        return villageScale;
    }
    
    public int getVillagePosX(){
        return villagePosX;
    }
    
    public int getVillagePosY(){
        return villagePosY;
    }
	
	public int getVillageWidth(){
		return villageWidth;
    }
	
	public int getVillageHeight(){
		return villageHeight;
    }
	
	public int getPercentLow(){
		return percentLow;
    }
	
	public int getPercentMiddle(){
		return percentMiddle;
    }
	
	public int getPercentHigh(){
		return percentHigh;
    }
	
	public int getSalaryLow(){
		return salaryLow;
    }
	
	public int getSalaryMiddle(){
		return salaryMiddle;
    }
	
	public int getSalaryHigh(){
		return salaryHigh;
    }

	public boolean getHasBus(){
		return hasBus;
	}
	
	public boolean getHasTrain(){
		return hasTrain;
	}
	
	public ArrayList<Habitant> getHabitantList(){
		return habitantList;
	}
	
	public ArrayList<Vehicle> getVehicleList(){
		return vehicleList;
	}
	
	public ArrayList<Vehicle> getCityVehicleList(){
		return cityVehicleList;
	}
	
	public Road getRoad(){
		return road;
	}
	
	public Float getEnterRoadKm(){
		return enterRoadKm;
	}
	
	public ArrayList<Group> getVillageGroups(){
		return habitantGroups;
	}
	
	/**
	 * add a group of habitants to the list of groups
	 *
	 * @param g	Group to add to the group list
	 */
	public void addGroup(Group g){
		habitantGroups.add(g);
	}
	
	/**
	 * Create a new habitant in the village
	 *
	 * @return 	Habitant added
	 */
	public Habitant newHabitant(String startAt, int agId){
		Habitant hab;
		int posX, posY;
		int ran, low, mid;
		int capital;

			low = getPercentLow();
			mid = getPercentMiddle();
			ran = (int) (Math.random() * 100);
			if (ran < low)
			{
				capital = (int) ( getSalaryLow() * (1 + 0.05 * (Math.random()*2 -1)) );
			}
			else if(ran < low+mid)
			{
				capital = (int) ( getSalaryMiddle() * (1 + 0.10 * (Math.random()*2 -1)) );
			}
			else
			{
				capital = (int) ( getSalaryHigh() * (1 + 0.15 * (Math.random()*2 -1)) );
			}
			
		//calculate the position of the agent in the village at random
		ran = (int) (Math.random() * villageWidth);
		posX = villagePosX + ran;
		ran = (int) (Math.random() * villageHeight);
		posY = villagePosY + ran;
		// Se deberia quitar el +1 ??
		hab = new Habitant(agId, "habitant"+(agId + 1), villageId, posX, posY, startAt, capital);
		habitantList.add(hab);
		return hab;
	}

	/**
	 * Create a new particular vehicle in the village
	 *
	 * @return Vehicle added
	 */
	public Vehicle newVehicle(Vehicle v){
		
		vehicleList.add(v);
		return v;
	}

	/**
	 * Create a new public vehicle in the village
	 *
	 * @return Vehicle added
	 */
	public Vehicle newCityVehicle(Vehicle v){

		vehicleList.add(v);
		cityVehicleList.add(v);
		return v;
	}

	/**
	 * add a vehicle to the vehicle list
	 *
	 * @param veh	Vehicle to add to the vehicle list
	 */
/*	public void addVehicle(Vehicle veh){
		if (!vehicleList.contains(veh)){
			vehicleList.add(veh);
		}
	}
*/	
	/**
	 * get an habitant from the habitant list
	 *
	 * @param id	identifier of the required habitant
	 *
	 * @return Habitant whether find it, else return null 
	 */
/*	public Habitant getHabitant(int id){
		return ??
	}
*/	
	/**
	 * get a vehicle from the vehicle list
	 *
	 * @param id	identifier of the required vehicle
	 *
	 * @return Vehicle whether find it, else return null 
	 */
	public Vehicle getVehicle(String id){
        for(Vehicle v: vehicleList){
            if (v.getVehicleId().equals(id)){
				return (v);
			}
        }
		return null;
	}
	
	/**
	 * get a group from the group list
	 *
	 * @param id	identifier of the required group
	 *
	 * @return Group whether find it, else return null 
	 */
	public Group getVillageGroup(int id){
		for (Group g : habitantGroups){
			if (id == g.getGroupId()){
				return g;
			}
		}
		return null;
	}
	
	/**
	 * show the village information
	 */
	public void show(){
        System.out.println ("-- Village -- ID:"+villageId+" NAME:"+villageName+" HABS:"+villageNumHabs+" N.Ag: "+ habitantList.size() + " N.Groups: "+ habitantGroups.size() +
		" LOW:"+percentLow+" MIDDLE:"+percentMiddle+" HIGH:"+percentHigh+" HAS_BUS:"+hasBus+
		" HAS_TRAIN:"+hasTrain);
    }
	
	/**
	 * show the habitant list information
	 */
	public void showHabitantList(){
        for(Habitant h: habitantList)
            h.show();
    }
	
	/**
	 * show the group list information
	 */
	public void showGroupList(){
        for(Group g: habitantGroups)
            g.show();
	}
	
	/**
	 * show the vehicle list information
	 */
	public void showVehicleList(){
        for(Vehicle v: vehicleList)
            v.show();
    }
	
	/**
	 * creates a dom element with the village information to save it in a xml file
	 */
    public org.w3c.dom.Element to_Villagelement(org.w3c.dom.Document document) {
        org.w3c.dom.Element elementVil = document.createElement("village");
		elementVil.setAttribute("id",new Integer(villageId).toString());
		elementVil.setAttribute("name",villageName);
		elementVil.setAttribute("numHabsReal",new Integer(villageNumHabs).toString());
		elementVil.setAttribute("scale",new Integer(villageScale).toString());
		elementVil.setAttribute("posVillageX",new Integer(villagePosX).toString());
		elementVil.setAttribute("posVillageY",new Integer(villagePosY).toString());
		elementVil.setAttribute("villageWidth",new Integer(villageWidth).toString());
		elementVil.setAttribute("villageHeight",new Integer(villageHeight).toString());
		elementVil.setAttribute("percentLow",new Integer(percentLow).toString());
		elementVil.setAttribute("percentMiddle",new Integer(percentMiddle).toString());
		elementVil.setAttribute("percentHigh",new Integer(percentHigh).toString());
		elementVil.setAttribute("hasBus",new Boolean(hasBus).toString());
		elementVil.setAttribute("hasTrain",new Boolean(hasTrain).toString());
        return elementVil;
    }	
}