package traffic;

import jason.environment.grid.GridWorldView;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;

/** 
 * class CO2Environment: view code for project jasonTeamSimLocal.mas2j
 *
 * @author Fco. Javier Cordero Cadenas
 */

public class WorldView extends GridWorldView {

	private static final long serialVersionUID = 1L;
	
	CO2Environment env = null;										//environment
    DefaultXYDataset datasetTime = new DefaultXYDataset();			//time dataset for graph
	DefaultXYDataset datasetMoney = new DefaultXYDataset();			//money dataset for graph
	DefaultXYDataset datasetMean = new DefaultXYDataset();			//mean dataset for graph
	DefaultXYDataset datasetEmissions = new DefaultXYDataset();		//emissions dataset for graph
	DefaultXYDataset datasetEstimatedTime = new DefaultXYDataset();	//estimated time dataset for graph
	DefaultXYDataset datasetPassengers = new DefaultXYDataset();		//passengers per vehicle
	
	/**
	 * class WorldView
	 *
	 * @param model
	 */
    public WorldView(WorldModel model) {
        super(model, "CO2 World", 750);
	   
		JFreeChart xycTime = ChartFactory.createXYLineChart("Time", "step", "Time", datasetTime, PlotOrientation.VERTICAL, true, true, true); 
		ChartFrame frameTime= new ChartFrame("Average time simulation", xycTime);
		frameTime.pack(); 
        frameTime.setVisible(true); 
		
		JFreeChart xycMoney = ChartFactory.createXYLineChart("Money", "step", "Money", datasetMoney, PlotOrientation.VERTICAL, false, true, true); 
		ChartFrame frameConsumption= new ChartFrame("Entire money simulation", xycMoney);
		frameConsumption.pack(); 
        frameConsumption.setVisible(true); 
		
		JFreeChart xycMean = ChartFactory.createXYLineChart("Habitants by Vehicle Type", "step", "number of habitants", datasetMean, PlotOrientation.VERTICAL, true, true, true); 
		ChartFrame frameMean= new ChartFrame("Number of habitants using each type of vehicles simulation", xycMean);
		frameMean.pack(); 
        frameMean.setVisible(true); 
		
		JFreeChart xycEmissions = ChartFactory.createXYLineChart("CO2 Emissions", "step", "Kg CO2", datasetEmissions, PlotOrientation.VERTICAL, false, true, true); 
		ChartFrame frameEmissions= new ChartFrame("Entire emissions of CO2 simulation", xycEmissions);
		frameEmissions.pack(); 
        frameEmissions.setVisible(true); 
		
		/*JFreeChart xycEstimatedTime = ChartFactory.createXYLineChart("Estimated Time data", "step", "Time", datasetEstimatedTime, PlotOrientation.VERTICAL, false, true, true); 
		ChartFrame frameEstimatedTime= new ChartFrame("Estimated time for each habitant simulation", xycEstimatedTime);
		frameEstimatedTime.pack(); 
        frameEstimatedTime.setVisible(true);*/ 
		
		JFreeChart xycPassengers = ChartFactory.createXYLineChart("Passengers per car", "step", "Passengers", datasetPassengers, PlotOrientation.VERTICAL, false, true, true); 
		ChartFrame framePassengers= new ChartFrame("Average passengers per vehicle simulation", xycPassengers);
		framePassengers.pack(); 
        framePassengers.setVisible(true); 
        //repaint();
    }

	/**
	 * add the time values for the graph
	 *
	 * @param key		name of the serie
	 * @param values	values to view
	 */
	public void addSerieTime(String key, double[][] values) {
        datasetTime.addSeries(key, values);
    }
	/**
	 * add the consumption values for the graph
	 *
	 * @param key		name of the serie
	 * @param values	values to view
	 */
	public void addSerieMoney(String key, double[][] values) {
        datasetMoney.addSeries(key, values);
    }
	/**
	 * add the mean values for the graph
	 *
	 * @param key		name of the serie
	 * @param values	values to view
	 */
	public void addSerieMean(String key, double[][] values) {
        datasetMean.addSeries(key, values);
    }
	/**
	 * add the emissions values for the graph
	 *
	 * @param key		name of the serie
	 * @param values	values to view
	 */
	public void addSerieEmissions(String key, double[][] values) {
        datasetEmissions.addSeries(key, values);
    }
	
	/**
	 * add the estimated time values of one habitant for the graph
	 *
	 * @param key		name of the serie
	 * @param values	values to view
	 */
	public void addSerieEstimatedTime(String key, double[][] values) {
        datasetEstimatedTime.addSeries(key, values);
    }
	
	/**
	 * add the average number of passengers who travel in a vehicle for the graph
	 *
	 * @param key		name of the serie
	 * @param values	values to view
	 */
	public void addSeriePassengers(String key, double[][] values) {
        datasetPassengers.addSeries(key, values);
    }
	
	/**
	 * set the environment
	 *
	 * @param env	environment
	 */
    public void setEnv(CO2Environment env) {
        this.env = env;
    }   
}
