// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://www.uv.es/grimo
// http://grev.uv.es
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Term;

import java.util.logging.Logger;

/** 
 * Internal function for adding an utility function to the MADeM agent.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.add_utility_function("package.UtilityFunctionName")</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class add_utility_function extends DefaultInternalAction  {

	private static final long serialVersionUID = 460589402971649349L;
	
	Logger logger = Logger.getLogger(add_utility_function.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		try
		{
			// Get the name of the utility function and the class from the arguments
			Atom uFuncNameTerm = (Atom) args[0];
			StringTerm uFuncTerm = (StringTerm) args[1];
			String uFuncClass = uFuncTerm.getString();

			// Register the new utility function
			MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
			if (agArch.addUtilityFunction(uFuncNameTerm, uFuncClass))
				logger.fine("Utility function " + uFuncClass + " correctly added with name " + uFuncNameTerm + ".");
			else
			{
				logger.severe("Error adding utility function " + args[0] + "with name " + uFuncNameTerm + ".");
				return false;
			}
		}
		catch (Exception e)
		{
			logger.severe("Error adding utility function "+ args[0] + " in class " + args[1]);
			e.printStackTrace();
    	    return false;
		}
		return true;
    }
}
