// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://www.uv.es/grimo
// http://grev.uv.es
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Atom;

import java.util.logging.Logger;

/** 
 * Internal function for getting the personal weight being applied to another agent's utilities.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.get_personal_weight(AgentName, Weight)</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class get_personal_weight extends DefaultInternalAction  {

	private static final long serialVersionUID = 1213078028798615578L;
	
	Logger logger = Logger.getLogger(get_personal_weight.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		try
		{
			// Get the utility weight 
			Atom agName = (Atom) args[0];
			MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
			NumberTerm weight = new NumberTermImpl(agArch.getPersonalWeight(agName));
			
			// Send response back 			
			return un.unifies(args[1], weight);
		}
		catch (Exception e)
		{
			logger.severe("Error getting personal weight.");
			e.printStackTrace();
			return false;
		}
    }
}
