// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://www.uv.es/grimo
// http://grev.uv.es
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Term;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTermImpl;

import java.util.Iterator;
import java.util.logging.Logger;

/** 
 * Internal function for getting the names of the utility functions already
 * registered in the MADeM agent.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.get_utility_function_names(ListOfNames)</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class get_utility_function_names extends DefaultInternalAction  {

	private static final long serialVersionUID = -2846820978255666224L;
	
	Logger logger = Logger.getLogger(get_utility_function_names.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		try
		{
			// Get the names of the utility functions
			MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
			Iterator<Atom> it = agArch.getUtilityFunctionNames().iterator();
			ListTermImpl res = new ListTermImpl();			
			while (it.hasNext())
				res.add(it.next());

			// Send the utility function names back			
			return un.unifies(args[0], res);
		}
		catch (Exception e)
		{
			logger.severe("Error getting utility function names.");
			e.printStackTrace();
    	    return false;
		}
    }
}
