// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://www.uv.es/grimo
// http://grev.uv.es
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Literal;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import java.util.logging.Logger;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;

/** 
 * Internal function for setting the personal weights of the MADeM agent.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.set_list_of_personal_weights([ jmadem_personal_weight(AgentName,Weight) | Tail ])</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class set_list_of_personal_weights extends DefaultInternalAction  {

	private static final long serialVersionUID = 179415558574138441L;
	
	Logger logger = Logger.getLogger(set_list_of_personal_weights.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		// Read the list of pairs with the new personal weights
		ConcurrentMap<Atom, Float> personalWeights = new ConcurrentHashMap<Atom, Float>();
		try
		{
			Iterator<Term> it = ((ListTerm) args[0]).iterator();
			while (it.hasNext())
			{
				Literal aux = (Literal) it.next();
				personalWeights.put( (Atom) aux.getTerm(0), 
								   new Float( ((NumberTerm) aux.getTerm(1)).solve()) );
			}
		}
		catch (Exception e)
		{
			logger.severe("Error changing personal weights.");
			e.printStackTrace();
			return false;
		}
		
		// Set the new personal weights
		MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
		if ( agArch.setPersonalWeights(personalWeights) )
			logger.fine("Personal weights correctly changed to " + personalWeights);
		else
			return false;
		
		return true;
    }
}
