// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://www.uv.es/grimo
// http://grev.uv.es
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Term;
import jason.asSyntax.Literal;

import java.util.logging.Logger;

/** 
 * Internal function for changing the type of multimodality used by the MADeM agent.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.multimodality(Multimodality)</tt> with <tt>Multimodality = competitive, aggregate</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class set_multimodality extends DefaultInternalAction  {

	private static final long serialVersionUID = -2895076925552865906L;
	
	Logger logger = Logger.getLogger(set_multimodality.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		try
		{
			// Get the welfare from the arguments
			String name_multimodality = ((Literal) args[0]).toString().toUpperCase();
			Multimodality m = (Multimodality)Enum.valueOf(Multimodality.class, name_multimodality);
					
			// Set the new welfare
			MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
			agArch.setMultimodality(m);
			logger.fine("Welfare correctly changed to " + name_multimodality);
		}
		catch (IllegalArgumentException e)
		{
			logger.severe("Error changing Multimodality to "+ args[0]);
			e.printStackTrace();
    	    return false;
		}
		return true;
    }
}
