// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://www.uv.es/grimo
// http://grev.uv.es
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.util.logging.Logger;

/** 
 * Internal function for changing the flag establishing whether the agent automatically
 * removes all the data related to a MADeM decision after it has been made.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.set_remove_MADeM_data(Value)</tt> with <tt>Value = true or false</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class set_remove_MADeM_data extends DefaultInternalAction  {

	private static final long serialVersionUID = 460589402971649349L;
	
	Logger logger = Logger.getLogger(set_remove_MADeM_data.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		boolean remove;
		
		try
		{
			// Get the name of the utility function from the arguments
			Term removeTerm = args[0];
			if (removeTerm instanceof VarTerm)
				removeTerm = ((VarTerm) removeTerm).capply(un);
			remove = ((Literal) removeTerm).toString().compareToIgnoreCase("true") == 0;
		}
		catch (Exception e)
		{
			logger.severe("Error reading parameters while changing the automatic remove of MADeM data flag.");
			e.printStackTrace();
    	    return false;
		}
					
		// Register the new utility function
		MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
		agArch.setAutomaticRemoveOfMademData(remove);

		return true;
    }
}
