// ----------------------------------------------------------------------------
// Copyright (C) 2008 Francisco Grimaldo, Miguel Lozano, Fernando Barber
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// francisco.grimaldo@uv.es, miguel.lozano@uv.es, fernando.barber@uv.es
// http://www.uv.es/grimo
// http://grev.uv.es
//
//----------------------------------------------------------------------------

package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;
import jason.asSyntax.Atom;

import java.util.logging.Logger;

/** 
 * Internal function for changing an utility weight of the MADeM agent.
 * <p>
 * <b>Use:</b> <br/> <tt>jmadem.set_utility_weight(UtilityName, Weight)</tt>
 * </p>
 *
 * @author Francisco Grimaldo
 */
public class set_utility_weight extends DefaultInternalAction  {

	private static final long serialVersionUID = -4251770750670387879L;
	
	Logger logger = Logger.getLogger(set_utility_weight.class.getName());

	@Override
	public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception 
	{
		// Read the new utility weight
		Atom utilityName = (Atom) args[0];
		Float weight = new Float( ((NumberTerm) args[1]).solve() );
		
		// Set the new utility weights
		MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
		if ( agArch.setUtilityWeight(utilityName, weight) )
			logger.fine("Utility weight of " + utilityName + " correctly changed to " + weight);
		else
			return false;
		
		return true;
    }
}
