function varargout = AEROGUI(varargin)
% AEROGUI MATLAB code for AEROGUI.fig
%      AEROGUI, by itself, creates a new AEROGUI or raises the existing
%      singleton*.
%
%      H = AEROGUI returns the handle to a new AEROGUI or the handle to
%      the existing singleton*.
%
%      AEROGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in AEROGUI.M with the given input arguments.
%
%      AEROGUI('Property','Value',...) creates a new AEROGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before AEROGUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to AEROGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help AEROGUI

% Last Modified by GUIDE v2.5 21-Mar-2014 18:51:43

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @AEROGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @AEROGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before AEROGUI is made visible.
function AEROGUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to AEROGUI (see VARARGIN)
warning off
donde=pwd;
filedonde=fopen('local.txt', 'w');
fprintf(filedonde, '%s\n', donde);
fprintf(filedonde, '1\n1\n');
fclose(filedonde);

fileunit=fopen('INTERFACE/units.txt', 'w');
fprintf(fileunit, '1\n');
fclose(fileunit);


%imshow('INTERFACE\logo.png')

% Choose default command line output for AEROGUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes AEROGUI wait for user response (see UIRESUME)
% uiwait(handles.aerogui2);


% --- Outputs from this function are returned to the command line.
function varargout = AEROGUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in atm.
function atm_Callback(hObject, eventdata, handles)
% hObject    handle to atm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.batch, 'Enable', 'off');
set(handles.batchpure, 'Enable', 'off');
set(handles.atm, 'Enable', 'off');
set(handles.km, 'Enable', 'off');
set(handles.m2g, 'Enable', 'off');

eval(['load INTERFACE/units.txt'])
unit=units(:,1);
if unit==1
 hj=warndlg('Each particle you consider must have a density in part/cm3', 'UNITS IN km-1');
 waitfor(hj);
else
 hj2=warndlg({'Particle density between 0 and 1 for each particle.';'The sum of all particle densities must be 1'}, 'UNITS IN m2/g');
 waitfor(hj2);
end
eval(['cd INTERFACE']);
AEG
close AEROGUI

% --- Executes when selected object is changed in panel_units.
function panel_units_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in panel_units 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
handles = guidata(hObject); 
filekm=fopen('INTERFACE/units.txt', 'w'); 
if hObject == handles.km
  fprintf(filekm, '1\n');
else
  fprintf(filekm, '0\n');
end
fclose(filekm)


% --- Executes on button press in batch.
function batch_Callback(hObject, eventdata, handles)
% hObject    handle to batch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Construct a questdlg with two options

set(handles.batch, 'Enable', 'off');
set(handles.batchpure, 'Enable', 'off');
set(handles.mixingrule, 'Enable', 'off');
set(handles.atm, 'Enable', 'off');
set(handles.km, 'Enable', 'off');
set(handles.m2g, 'Enable', 'off');

quest='LOADING FILE FOR BATCH MODE';
alt={'The input TEXT file (in INPUTS folder) should have the following columns',...
    '__________________________________________________________________',...
    ' ',...
    'Counter lambda Rcore Sigma n_core k_core dens fcoat n_shell k_shell',...
    '___________________________________________________________________',...
    ' ',...
    '(1) Counter: integer from 1 to N (N: number of runs)',...
    '(2) lambda: wavelength in micrometers',...
    '(3) Rcore: core radius in micrometers',...
    '(4) Sigma: standard deviation of the size distribution',...
    '(5) n_core: real part of the core refractive index',...
    '(6) k_core: imaginary part of the core refractive index',...
    '(7) dens: core density (g/cm3)',...
    '(8) fcoat=(Rshell-Rcore)/Rcore, being Rshell the shell radius (micr.)',...
    '(9) n_shell: real part of the shell refractive index',...
    '(10) k_shell: imaginary part of the shell refractive index',...
    ' ',...
    ' '};
string=[quest,'\n'];
for j=1:length(alt)
    string=[string,'\n',alt{j}];
end
string=[string,'\n'];
string=sprintf(string);%this makes \n work
prompt={string};

choice = questdlg(prompt, ...
	'BATCH MODE', ...
	'SELECT FILE','CANCEL','CANCEL');
% Handle response
switch choice
    case 'SELECT FILE'
        
        [FileName2,PathName,FilterIndex] = uigetfile('*.txt','Select the input file');
         perico2=strcat(PathName, FileName2);
         nombre=FileName2;
    case 'CANCEL'
        error('QUITTING BATCH MODE AS REQUESTED');
end


filename = 'local.txt';
delimiterIn = ' ';
headerlinesIn = 1;
A = importdata(filename,delimiterIn,headerlinesIn);
%disp(A.colheaders{1, 1})
camino=A.colheaders{1, 1};
monigote=strcat(A.colheaders{1, 1}, '\INTERFACE\datos.txt');
 
copyfile(perico2, monigote, 'f');
%eval(['copyfile ', char(nombre), ' ', char(donde), '\datos.txt f']);
cd(char(camino));

fih=warndlg('The calculations may take several minutes','Batch mode');
waitfor(fih);

cd INTERFACE; 

! zznunits.exe
Z_GENERICO_PURE_units;
Z_GENERICO_COATED_units;
! zzreadunits.exe
fclose all


eval(['load cuenta.txt']);
cuentame=cuenta(:, 1);

file1=fopen('cuenta.txt', 'w');
fprintf(file1, '%i\n', cuenta+1);
fclose(file1);

eval(['mkdir ../OUTPUTS/RUN-batch-', num2str(cuenta)]);

eval(['copyfile zz_abs_enh.txt ../OUTPUTS/RUN-batch-', num2str(cuenta), '/', char(nombre), '_absorption_amplification.txt f']);
eval(['copyfile z_Output_units.txt ../OUTPUTS/RUN-batch-', num2str(cuenta), '/', char(nombre), '_coated_opt_prop.txt f']);
eval(['copyfile z_Output_pure_units.txt ../OUTPUTS/RUN-batch-', num2str(cuenta), '/', char(nombre), '_pure_opt_prop.txt f']);


nino=strcat('RESULTS IN OUTPUT/RUN-batch', num2str(cuenta));
msgbox(nino, 'Warning', 'modal');


cd ..


% --- Executes on button press in exitaerogui.
function exitaerogui_Callback(hObject, eventdata, handles)
% hObject    handle to exitaerogui (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%close all;
close(handles.aerogui2)

% --- Executes during object creation, after setting all properties.
function batch_CreateFcn(hObject, eventdata, handles)
% hObject    handle to batch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes on button press in batchpure.
function batchpure_Callback(hObject, eventdata, handles)
% hObject    handle to batchpure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.batch, 'Enable', 'off');
set(handles.batchpure, 'Enable', 'off');
set(handles.mixingrule, 'Enable', 'off');
set(handles.mixingrule, 'Enable', 'off');
set(handles.atm, 'Enable', 'off');
set(handles.km, 'Enable', 'off');
set(handles.m2g, 'Enable', 'off');

quest='LOADING FILE FOR BATCH MODE: PURE COMPONENT';
alt={'The input TEXT file (in INPUTS folder) should have the following columns',...
    '__________________________________________________________________',...
    ' ',...
    'Counter lambda Rcore Sigma n_core k_core dens ',...
    '___________________________________________________________________',...
    ' ',...
    '(1) Counter: integer from 1 to N (N: number of runs)',...
    '(2) lambda: wavelength in micrometers',...
    '(3) Rcore: core radius in micrometers',...
    '(4) Sigma: standard deviation of the size distribution',...
    '(5) n_core: real part of the core refractive index',...
    '(6) k_core: imaginary part of the core refractive index',...
    '(7) dens: core density (g/cm3)',...
    ' ',...
    ' '};
string=[quest,'\n'];
for j=1:length(alt)
    string=[string,'\n',alt{j}];
end
string=[string,'\n'];
string=sprintf(string);%this makes \n work
prompt={string};

choice = questdlg(prompt, ...
	'BATCH MODE: pure component', ...
	'SELECT FILE','CANCEL','CANCEL');
% Handle response
switch choice
    case 'SELECT FILE'
        
%         nombre = uigetfile('*.txt','Select the input file')
  
   [FileName,PathName,FilterIndex] = uigetfile('*.txt','Select the input file');
   perico=strcat(PathName, FileName);
   nombre=FileName;
    case 'CANCEL'
        error('QUITTING BATCH MODE AS REQUESTED');
end


filename = 'local.txt';
delimiterIn = ' ';
headerlinesIn = 1;
A = importdata(filename,delimiterIn,headerlinesIn);
%disp(A.colheaders{1, 1})
camino=A.colheaders{1, 1};
monigote=strcat(A.colheaders{1, 1}, '\INTERFACE\datos.txt');
 
copyfile(perico, monigote, 'f')
%eval(['copyfile ', char(nombre), ' ', char(donde), '\datos.txt f']);
cd(char(camino));

fih=warndlg('The calculations may take several minutes','Batch mode: pure component');
waitfor(fih);

cd INTERFACE; 

! zznunits.exe
Z_GENERICO_PURE_units;
fclose all


eval(['load cuenta.txt']);
cuentame=cuenta(:, 1);

file1=fopen('cuenta.txt', 'w');
fprintf(file1, '%i\n', cuenta+1);
fclose(file1);

eval(['mkdir ../OUTPUTS/RUN-batch-', num2str(cuenta)]);

eval(['copyfile z_Output_pure_units.txt ../OUTPUTS/RUN-batch-', num2str(cuenta), '/', char(nombre), '_pure_opt_prop.txt f']);


nino=strcat('RESULTS IN OUTPUT/RUN-batch', num2str(cuenta));
msgbox(nino, 'Warning', 'modal');



cd ..


% --- Executes on button press in mixingrule.
function mixingrule_Callback(hObject, eventdata, handles)
% hObject    handle to mixingrule (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.batch, 'Enable', 'off');
set(handles.batchpure, 'Enable', 'off');
set(handles.mixingrule, 'Enable', 'off');
set(handles.atm, 'Enable', 'off');
set(handles.km, 'Enable', 'off');
set(handles.m2g, 'Enable', 'off');

cd INTERFACE
AE_MIXING



function outo_Callback(hObject, eventdata, handles)
% hObject    handle to outo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of outo as text
%        str2double(get(hObject,'String')) returns contents of outo as a double


% --- Executes during object creation, after setting all properties.
function outo_CreateFcn(hObject, eventdata, handles)
% hObject    handle to outo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






% --- Executes during object creation, after setting all properties.
function axes2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
handles.output = hObject;
% axes(handle.axes2)
imshow('INTERFACE\logo.png')

% Update handles structure
guidata(hObject, handles);
% Hint: place code in OpeningFcn to populate axes2
