% dust COATED SPHERE WITH USER DEFINED REFRACTIVE INDEX (user1) 
% 26 March 2012
% Roberto Pedrs pedrose@uv.es

% Type 2: 2 euro coin coating 
% The core and shell are different entities (the core is not  a "filling")
% fcoat is the fractional increase in diameter due to coating
% fcoat=(Rshell-Rcore)/Rcore

function LRT3=Ndust_user1(Rdust, sigma, fcoat, lay)
global lambda ext_coef sca_coef abs_coef ssa asym_param ABS_AMPLIF



% Output file
% Headers

 %eval(['load layer.txt']);
 %lay=layer(:,1);

% READING THE UNITS SELECTION: 1 is km-1; 0 is m2/g
eval(['load units.txt;']);
unit=units(:,1);

% READING CORE DENSITY (g/cm3)
eval(['load LAYER', num2str(lay), '/dustUSER1/densdust.txt'])
dens=densdust(:, 1);

 filecoated=fopen('coated_dust_user1.txt', 'w'); 
 % fprintf(filecoated, 'LAMBDA\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');


 
 % 1 corresponds to core:  dust
 % 2 corresponds to shell: user1

 
 eval(['load LAYER', num2str(lay), '/dustUSER1/nr_coating_user1.txt'])  
 lams=nr_coating_user1(:, 1);
 nsr=nr_coating_user1(:, 2);
 nsi=nr_coating_user1(:, 3); 
  
 
 eval(['load LAYER', num2str(lay), '/dustUSER1/nr_dust2.txt'])
 lamso=nr_dust2(:, 1);
 nsor=nr_dust2(:, 2);
 nsoi=nr_dust2(:, 3); 
 
  % fcoat input
 eval(['load LAYER', num2str(lay), '/dustUSER1/tmp_fcoat_dust.txt'])  ;
 fcoat=tmp_fcoat_dust(:, 1);

 
 h = waitbar(0,'Computing user defined (1) coated dust. Please wait...');
 for k = 1:1:27 % wavelength selection
  lambda=lams(k); % in microns
   m1=nsor(k)+i*nsoi(k);
   m2=nsr(k)+i*nsi(k);
   
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%  dust + user1  %%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % initialization
   ext_coef=0;
   sca_coef=0;
   asy_par1=0;
   asy_par2=0;
   abs_coef=0;   
   vol_tot=0;
   
   % Determining the step in the lognormal integration dj 
   if Rdust<0.02  
    dj=0.001;
   else Rdust>=0.02
    if sigma<1.4
     dj=0.001;
    else sigma>=1.4
     dj=0.01;
    end  % if sigma<1.4 ends
   end  % if Rdust<0.02 ends
   
  % Lognormal integration upper limit radius
   if Rdust>1
    limite=4+Rdust;
   elseif (Rdust>=0.5 && Rdust<1) 
    limite=2+Rdust;
   else
    limite=1+Rdust;
   end  % Rdust>1 ends

   for j = 5e-3:dj:limite % j is the core radius in the lognormal
    Rcore=j;        % core radius
    Rshell=Rcore*(1+fcoat); % shell radius
       % Note that 0<=x<=y;   (Mtzler, 2002).
    % Thus, the minimum shell diameter is the core diameter
    x=2*pi*Rcore/lambda; % Lognormal size distribution for dust (x=2*pi*r/lambda)
    y=2*pi*Rshell/lambda; % user1 diameter 
    B=Miecoated(m1,m2,x,y,1);
    
    Qext=B(:, 1); % Efficiency for extinction
    Qsca=B(:, 2); % Efficiency for scattering
    Qabs=B(:, 3); % Efficiency for absorption
    Qb=B(:, 4);   % Efficiency for backscattering
    g=B(:, 5);    % Asymmetry parameter
    qratio=B(:, 6); % Backscattering / scattering
    
    % Lognormal size distribution 
    % (lognormal dust + constant coating)
    lognr=lognormal(Rcore, Rdust, sigma); 
        
    sigma_e=pi*Rshell^2*Qext*lognr*dj;  % extinction coefficient value
    sigma_s=pi*Rshell^2*Qsca*lognr*dj;  % scattering coefficient value
    sigma_a=pi*Rshell^2*Qabs*lognr*dj;  % absorption coefficient value
    sigma_g=g*lognr*dj;     % asymmetry parameter (integrated for the size distribution)
    
    % total volume calculation
    vol_tot=vol_tot+(4*pi/3)*Rcore^3*lognr*dj;

    ext_coef=ext_coef+sigma_e;      % extinction coefficient integration
    abs_coef=abs_coef+sigma_a;      % absorption coefficient integration
    sca_coef=sca_coef+sigma_s;      % scattering coefficient integration
    asy_par1=asy_par1+g*pi*Rshell^2*Qsca*lognr*dj;  % asymmetry parameter integration
    asy_par2=asy_par2+pi*Rshell^2*Qsca*lognr*dj;
     
   end  % for j = 5e-3:dj:limite ends
 
   ssa=sca_coef/ext_coef; %single scattering albedo
   asy_par=asy_par1/asy_par2;

   if abs_coef<0
     abs_coef=0;
   end % abs_coef<0 ends
   % fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coef*1e-3, sca_coef*1e-3, abs_coef*1e-3, ssa, asy_par);
   %  fprintf(filecoated, '%d\t%d\t%d\n', Rdust, 2*Rdust*pi/lambda, abs_coef*1e-3);

%     if isnan(ext_coef)==0
%     if unit==1   
%      fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coef*1e-3, sca_coef*1e-3, abs_coef*1e-3, ssa, asy_par); 
%     elseif unit==0
%          res=zfc8(lambda, Rdust, sigma, m1, m2, fcoat);   
%     fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, res(2), res(3), res(4), res(5), res(6));
%     end
%    end



    if isnan(ext_coef)==0
    if unit==1   
     fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coef*1e-3, sca_coef*1e-3, abs_coef*1e-3, ssa, asy_par); 
    elseif unit==0
     fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coef/(vol_tot*dens), sca_coef/(vol_tot*dens), abs_coef/(vol_tot*dens), ssa, asy_par);
    end
   else
    res=zfc8(lambda, Rdust, sigma, m1, m2, fcoat);   
    fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, res(2), res(3), res(4), res(5), res(6));
   end

   waitbar(k/27,h);
   
 end  % for k = 1:1:27 ends
 
 close(h);
 eval(['copyfile coated_dust_user1.txt LAYER', num2str(lay),'/coated_dust_user1.txt f']);
 eval(['load LAYER', num2str(lay), '/coated_dust_user1.txt']) ; 
 control=coated_dust_user1(:,2);
 if isnan(control)==1
     errordlg('INVALID PARAMETERS','ERROR');
 end  % isnan(control)==1 ends
 LRT3=coated_dust_user1;

fclose(filecoated);

sound(10)
 
