% PURE biomass optical properties in Mixing layer
% Npurebiomass.m
% One radius and one sigma
% 15 March 2012
% Roberto Pedrs pedrose@uv.es

% READING biomass8 INPUT PARAMETERS: RADIUS AND SIGMA
function LRT2= Npurebiomass(Rbiomass, rbiomassmin, rbiomassmax, sigma, biomass, laye)
  global lambda ext_coef sca_coef abs_coef ssa asym_param ABS_AMPLIF
 

 %eval(['load layer.txt']); 
 %laye=layer(:,1);
 

 eval(['load LAYER', num2str(laye), '/nr_biomass.txt'])
 lamso=nr_biomass(:, 1);
 nsor=nr_biomass(:, 2);
 nsoi=nr_biomass(:, 3); 
 
 eval(['load LAYER', num2str(laye), '/tmp_biomassa.txt']);
 coefa=tmp_biomassa(:,1);
 eval(['load LAYER', num2str(laye), '/tmp_biomassb.txt']);
 coefb=tmp_biomassb(:,1);
 eval(['load hr.txt']);
 relhum=hr(:,1);

 % READING THE UNITS SELECTION: 1 is km-1; 0 is m2/g
 eval(['load units.txt;']);
 unit=units(:,1);
 
 % READING DENSITY (g/cm3)
 eval(['load densbiomass.txt'])
 dens=densbiomass(:,1);


  % Determining the step in the lognormal integration dj 
  if Rbiomass<0.02  
   dj=0.001;
  else Rbiomass>=0.02
   if sigma<1.4
    dj=0.001;
   end
   if sigma>=1.4
    dj=0.01;
   end
  end

 % biomass output file
 filebiomass=fopen('out_pbiomass.txt', 'w'); 
 % Headers
 % fprintf(filebiomass, 'lambda\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');

  % It shows a bar with the status      
  h = waitbar(0,'Computing pure biomass (user defined mode). Please wait...');
  for k = 1:27 % wavelength loop
   lambda=lamso(k);
   m1=nsor(k)+i*nsoi(k);

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%% PURE biomass ABSORPTION COEFFICIENT %%%%%%%%%%%%%%

   ext_coefp=0;
   sca_coefp=0;
   asy_par1p=0;
   asy_par2p=0;
   abs_coefp=0;   % initialization
   vol_tot=0;

 %  if Rbiomass>1
 %    limite=4+Rbiomass;
 %  elseif (Rbiomass>=0.5 && Rbiomass<1) 
 %    limite=2+Rbiomass;
 %  else
 %    limite=1+Rbiomass;
 %  end

   for j = rbiomassmin:dj:rbiomassmax   %j is the particle radius
    xp=2*pi*j/lambda;
    Ap=Mie(m1, xp);
    Qextp=Ap(:, 1); %efficiency for extinction
    Qscap=Ap(:, 2); %efficiency for scattering
    Qabsp=Ap(:, 3); %efficiency for absorption
    Qbp=Ap(:, 4);   %efficiency for backscattering
    gp=Ap(:, 5);    %asymmetry parameter
    qratiop=Ap(:, 6); % backscattering / scattering
    nrp=lognormal(j, Rbiomass, sigma); % lognormal size distribution
                                % particles per m3
    vol_tot=vol_tot+(4*pi/3)*Rbiomass^3*nrp*dj;
  
    sigma_ep=pi*j^2*Qextp*nrp*dj;  % extinction coefficient value
    sigma_sp=pi*j^2*Qscap*nrp*dj;  % scattering coefficient value
    sigma_ap=pi*j^2*Qabsp*nrp*dj;  % absorption coefficient value
    sigma_gp=gp*nrp*dj;     % asymmetry parameter (integrated for the size distribution)
    
    ext_coefp=ext_coefp+sigma_ep;      % extinction coefficient integration
    abs_coefp=abs_coefp+sigma_ap;      % absorption coefficient integration
    sca_coefp=sca_coefp+sigma_sp;      % scattering coefficient integration
    asy_par1p=asy_par1p+gp*pi*j^2*Qscap*nrp*dj;        % asymmetry parameter integration
    asy_par2p=asy_par2p+pi*j^2*Qscap*nrp*dj;
   
   
   end 
   ssap=sca_coefp/ext_coefp; %single scattering albedo
   asy_parp=asy_par1p/asy_par2p;

  if unit==1   
     % We have to include a 1e-3 factor to convert from micr2/cm3 into km2/km3=km-1
     fprintf(filebiomass, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp*1e-3, sca_coefp*1e-3, abs_coefp*1e-3, ssap, asy_parp); 
   elseif unit==0
     fprintf(filebiomass, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp/(vol_tot*dens), sca_coefp/(vol_tot*dens), abs_coefp/(vol_tot*dens), ssap, asy_parp);
   end

   
  waitbar(k/27,h); 
  end
  close(h);
  fclose(filebiomass);
  eval(['load out_pbiomass.txt']) ; 
  control=out_pbiomass(:,2);
 if isnan(control)==1
   errordlg('INVALID biomass MODE ', num2str(biomass),' PARAMETERS','ERROR');
   exit;
 else
   eval(['copyfile out_pbiomass.txt out_pbiomass', num2str(biomass), '.txt f']);
   
   LRT2=out_pbiomass;
 end
 



sound(10)
  
 
