% PURE ocacc optical properties in Mixing layer
% Npureocacc.m
% One radius and one sigma
% 12 April 2012
% Roberto Pedrs pedrose@uv.es




% READING ocacc INPUT PARAMETERS: RADIUS AND SIGMA
function LRT2=Npureocacc(Rocacc, sigma)
  global lambda ext_coef sca_coef abs_coef ssa asym_param ABS_AMPLIF
 

 eval(['load layer.txt']); 
 laye=layer(:,1);
 
 % READING THE UNITS SELECTION: 1 is km-1; 0 is m2/g
 eval(['load units.txt;']);
 unit=units(:,1);
 
 % READING DENSITY (g/cm3)
 eval(['load LAYER', num2str(laye), '/densoc.txt'])
 dens=densoc(:,1);
 
 
 eval(['load LAYER', num2str(laye), '/nr_oc.txt'])
 lamso=nr_oc(:, 1);
 nsor=nr_oc(:, 2);
 nsoi=nr_oc(:, 3); 

  % Determining the step in the lognormal integration dj 
  if Rocacc<0.02  
   dj=0.001;
  else Rocacc>=0.02
   if sigma<1.4
    dj=0.001;
   end
   if sigma>=1.4
    dj=0.01;
   end
  end

 % ocacc output file
 fileocacc=fopen('out_pocacc.txt', 'w'); 
 % Headers
 % fprintf(fileocacc, 'lambda\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');

 

  % It shows a bar with the status      
  h = waitbar(0,'Computing pure ocacc. Please wait...');
  for k = 1:27 % wavelength loop
   lambda=lamso(k);
   m1=nsor(k)+i*nsoi(k);

 
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%% PURE ocacc ABSORPTION COEFFICIENT %%%%%%%%%%%%%%

   ext_coefp=0;
   sca_coefp=0;
   asy_par1p=0;
   asy_par2p=0;
   abs_coefp=0;   % initialization
   vol_tot=0;

   for j = 5e-3:dj:1+Rocacc   %j is the particle radius
    xp=2*pi*j/lambda;
    Ap=Mie(m1, xp);
    Qextp=Ap(:, 1); %efficiency for extinction
    Qscap=Ap(:, 2); %efficiency for scattering
    Qabsp=Ap(:, 3); %efficiency for absorption
    Qbp=Ap(:, 4);   %efficiency for backscattering
    gp=Ap(:, 5);    %asymmetry parameter
    qratiop=Ap(:, 6); % backscattering / scattering
    nrp=lognormal(j, Rocacc, sigma); % lognormal size distribution
                                % particles per m3
    vol_tot=vol_tot+(4*pi/3)*Rocacc^3*nrp*dj;  

    sigma_ep=pi*j^2*Qextp*nrp*dj;  % extinction coefficient value
    sigma_sp=pi*j^2*Qscap*nrp*dj;  % scattering coefficient value
    sigma_ap=pi*j^2*Qabsp*nrp*dj;  % absorption coefficient value
    sigma_gp=gp*nrp*dj;     % asymmetry parameter (integrated for the size distribution)
    
    ext_coefp=ext_coefp+sigma_ep;      % extinction coefficient integration
    abs_coefp=abs_coefp+sigma_ap;      % absorption coefficient integration
    sca_coefp=sca_coefp+sigma_sp;      % scattering coefficient integration
    asy_par1p=asy_par1p+gp*pi*j^2*Qscap*nrp*dj;        % asymmetry parameter integration
    asy_par2p=asy_par2p+pi*j^2*Qscap*nrp*dj;
   
   
   end 
   ssap=sca_coefp/ext_coefp; %single scattering albedo
   asy_parp=asy_par1p/asy_par2p;

   if unit==1   
     % We have to include a 1e-3 factor to convert from micr2/cm3 into km2/km3=km-1
     fprintf(fileocacc, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp*1e-3, sca_coefp*1e-3, abs_coefp*1e-3, ssap, asy_parp); 
   elseif unit==0
     fprintf(fileocacc, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp/(vol_tot*dens), sca_coefp/(vol_tot*dens), abs_coefp/(vol_tot*dens), ssap, asy_parp);
   end

   
  waitbar(k/27,h); 
  end
  close(h);
  fclose(fileocacc);
  eval(['copyfile out_pocacc.txt LAYER', num2str(laye),'/out_pocacc.txt f']);
 eval(['load LAYER', num2str(laye), '/out_pocacc.txt']) ; 
 control=out_pocacc(:,2);
 if isnan(control)==1
     errordlg('INVALID ocacc PARAMETERS','ERROR');
 end
 LRT2=out_pocacc;



sound(10)
  
 
