% PURE ocphi optical properties in Mixing layer
% Npureocphi.m
% One radius and one sigma
% 3 Mar 2012
% Roberto Pedrs pedrose@uv.es

% READING ocphi8 INPUT PARAMETERS: RADIUS AND SIGMA
function LRT2= Npureocphi(Rocphi0, rocphimin, rocphimax, sigma, ocphii)
  global ext_coef sca_coef abs_coef ssa asym_param ABS_AMPLIF
 

 eval(['load layer.txt']); 
 laye=layer(:,1);
 
% Dry OC hydrophilic
 eval(['load NRHR/ocphi.txt'])
 lamso=ocphi(:, 1);
 nsord=ocphi(:, 2);
 nsoid=ocphi(:, 3); 
 
 eval(['load NRHR/water.txt'])
 nwr=water(:, 2);
 nwi=water(:, 3);

 eval(['load gro.txt']);
 growth=gro(:,1);
 Rocphi=Rocphi0*growth;



 Ddry=2.0*Rocphi0;
 Dwet=2.0*Rocphi;

 % READING IF MANUAL ENTRY IN REFRACTIVE INDEX OF OCPHI
 
 eval(['cd LAYER', num2str(laye)]);
 ftest=fopen('manualocphi.txt', 'r');
 cd ..
 if (ftest==-1)
 % VOLUMEN WEIGHTED REFRACTIVE INDEX OF HYDRATED OC
  nsor=(Ddry^3*nsord+(Dwet^3-Ddry^3)*nwr)/Dwet^3;
  nsoi=(Ddry^3*nsoid+(Dwet^3-Ddry^3)*nwi)/Dwet^3;
 else
  eval(['load LAYER', num2str(laye), '/nr_ocphi.txt'])
  lamso=nr_ocphi(:, 1);
  nsor=nr_ocphi(:, 2);
  nsoi=nr_ocphi(:, 3); 
  fclose(ftest);
 end


file12=fopen('tmp_nr_ocphi.txt', 'w')
for k=1:24
 fprintf(file12, '%d\t%d\t%d\n', lamso(k), nsor(k), nsoi(k));
end
fclose(file12);
 eval(['copyfile tmp_nr_ocphi.txt LAYER', num2str(laye), '/nr_ocphi__.txt f'])

 % READING THE UNITS SELECTION: 1 is km-1; 0 is m2/g
 eval(['load units.txt;']);
 unit=units(:,1);
 
 % READING DENSITY (g/cm3)
 eval(['load LAYER', num2str(laye), '/densocphi.txt'])
 dens0=densocphi(:,1);

  % Hygroscopic growth in density
 dens=dens0*(Rocphi0/Rocphi)^3+(1-(Rocphi0/Rocphi)^3)*1.0;

  % Determining the step in the lognormal integration dj 
  if Rocphi<0.02  
   dj=0.001;
  else Rocphi>=0.02
   if sigma<1.4
    dj=0.001;
   end
   if sigma>=1.4
    dj=0.01;
   end
  end

 % ocphi output file
 fileocphi=fopen('out_pocphi.txt', 'w'); 
 % Headers
 % fprintf(fileocphi, 'lambda\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');

  % It shows a bar with the status      
  h = waitbar(0,'Computing pure ocphi (user defined mode). Please wait...');
  for k = 1:27 % wavelength loop
   lambda=lamso(k);
   m1=nsor(k)+i*nsoi(k);

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%% PURE ocphi ABSORPTION COEFFICIENT %%%%%%%%%%%%%%

   ext_coefp=0;
   sca_coefp=0;
   asy_par1p=0;
   asy_par2p=0;
   abs_coefp=0;   % initialization
   vol_tot=0;

 %  if Rocphi>1
 %    limite=4+Rocphi;
 %  elseif (Rocphi>=0.5 && Rocphi<1) 
 %    limite=2+Rocphi;
 %  else
 %    limite=1+Rocphi;
 %  end

   for j = rocphimin:dj:rocphimax   %j is the particle radius
    xp=2*pi*j/lambda;
    Ap=Mie(m1, xp);
    Qextp=Ap(:, 1); %efficiency for extinction
    Qscap=Ap(:, 2); %efficiency for scattering
    Qabsp=Ap(:, 3); %efficiency for absorption
    Qbp=Ap(:, 4);   %efficiency for backscattering
    gp=Ap(:, 5);    %asymmetry parameter
    qratiop=Ap(:, 6); % backscattering / scattering
    nrp=lognormal(j, Rocphi, sigma); % lognormal size distribution
                                % particles per m3
    vol_tot=vol_tot+(4*pi/3)*Rocphi^3*nrp*dj;
  
    sigma_ep=pi*j^2*Qextp*nrp*dj;  % extinction coefficient value
    sigma_sp=pi*j^2*Qscap*nrp*dj;  % scattering coefficient value
    sigma_ap=pi*j^2*Qabsp*nrp*dj;  % absorption coefficient value
    sigma_gp=gp*nrp*dj;     % asymmetry parameter (integrated for the size distribution)
    
    ext_coefp=ext_coefp+sigma_ep;      % extinction coefficient integration
    abs_coefp=abs_coefp+sigma_ap;      % absorption coefficient integration
    sca_coefp=sca_coefp+sigma_sp;      % scattering coefficient integration
    asy_par1p=asy_par1p+gp*pi*j^2*Qscap*nrp*dj;        % asymmetry parameter integration
    asy_par2p=asy_par2p+pi*j^2*Qscap*nrp*dj;
   
   
   end 
   ssap=sca_coefp/ext_coefp; %single scattering albedo
   asy_parp=asy_par1p/asy_par2p;

   if unit==1   
     % We have to include a 1e-3 factor to convert from micr2/cm3 into km2/km3=km-1
     fprintf(fileocphi, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp*1e-3, sca_coefp*1e-3, abs_coefp*1e-3, ssap, asy_parp); 
   elseif unit==0
     fprintf(fileocphi, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp/(vol_tot*dens), sca_coefp/(vol_tot*dens), abs_coefp/(vol_tot*dens), ssap, asy_parp);
   end

   
  waitbar(k/27,h); 
  end
  close(h);
  fclose(fileocphi);
  eval(['load out_pocphi.txt']) ; 
  control=out_pocphi(:,2);
 if isnan(control)==1
   errordlg('INVALID ocphi MODE ', num2str(ocphi),' PARAMETERS','ERROR');
   exit;
 else
   eval(['copyfile out_pocphi.txt out_pocphi', num2str(ocphii), '.txt f']);
   
   LRT2=out_pocphi;
 end
 



sound(10)
  
 
