% PURE seasalt optical properties in Mixing layer
% Npureseasalt.m
% One radius and one sigma
% 3 Mar 2012
% Roberto Pedrs pedrose@uv.es

% READING seasalt8 INPUT PARAMETERS: RADIUS AND SIGMA
function LRT2= Npureseasalt(Rseasalt0, rseasaltmin, rseasaltmax, sigma, seasalt)
  global lambda ext_coef sca_coef abs_coef ssa asym_param ABS_AMPLIF
 

 eval(['load layer.txt']); 
 laye=layer(:,1);
 

 eval(['load LAYER', num2str(laye), '/nr_seasalt.txt'])
 lamso=nr_seasalt(:, 1);
 nsor=nr_seasalt(:, 2);
 nsoi=nr_seasalt(:, 3); 
 
 % Growth using the Khler equation
 %eval(['load gro.txt']);
 %growth=gro(:,1);
 %Rseasalt=Rseasalt0*growth;

 % Checking if user-defined growth has been selected
 filegrossa=fopen('growthss.txt', 'r');
 if (filegrossa==-1) % default hygroscopic growth
  % Hygroscopic growth by Gerber (1985)
  %  Gerber HE (1985) Relative humidity parameterization of the Navy
  %  Aerosol Model (NAM).Navy Research Lab, Washington DC

  % Reading RH (%)
  eval(['load hr.txt']);
  hum=hr(:, 1);
  RH=hum/100.0;
  rd=Rseasalt0;

  C1=0.7674;
  C2=3.079;
  C3=2.572e-11;
  C4=-1.424;
  rw=( C1*rd^C2/(C3*rd^C4-log(RH)) + rd^3   )^(1/3);

  Rseasalt=rw;
 else
  eval(['load growthss.txt']);
  growth=growthss(:, 1)
  Rseasalt=Rseasalt0*growth
 end



 % READING THE UNITS SELECTION: 1 is km-1; 0 is m2/g
 eval(['load units.txt;']);
 unit=units(:,1);
 
 % READING DENSITY (g/cm3)
 eval(['load LAYER', num2str(laye), '/denseasalt.txt'])
 dens0=denseasalt(:,1);

 % Hygroscopic growth in density
 dens=dens0*(Rseasalt0/Rseasalt)^3+(1-(Rseasalt0/Rseasalt)^3)*1.0;

  % Determining the step in the lognormal integration dj 
  if Rseasalt<0.02  
   dj=0.001;
  else Rseasalt>=0.02
   if sigma<1.4
    dj=0.001;
   end
   if sigma>=1.4
    dj=0.01;
   end
  end

 % seasalt output file
 fileseasalt=fopen('out_pseasalt.txt', 'w'); 
 % Headers
 % fprintf(fileseasalt, 'lambda\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');

  % It shows a bar with the status      
  h = waitbar(0,'Computing pure seasalt (user defined mode). Please wait...');
  for k = 1:27 % wavelength loop
   lambda=lamso(k);
   m1=nsor(k)+i*nsoi(k);

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%% PURE seasalt ABSORPTION COEFFICIENT %%%%%%%%%%%%%%

   ext_coefp=0;
   sca_coefp=0;
   asy_par1p=0;
   asy_par2p=0;
   abs_coefp=0;   % initialization
   vol_tot=0;

 %  if Rseasalt>1
 %    limite=4+Rseasalt;
 %  elseif (Rseasalt>=0.5 && Rseasalt<1) 
 %    limite=2+Rseasalt;
 %  else
 %    limite=1+Rseasalt;
 %  end

   for j = rseasaltmin:dj:rseasaltmax   %j is the particle radius
    xp=2*pi*j/lambda;
    Ap=Mie(m1, xp);
    Qextp=Ap(:, 1); %efficiency for extinction
    Qscap=Ap(:, 2); %efficiency for scattering
    Qabsp=Ap(:, 3); %efficiency for absorption
    Qbp=Ap(:, 4);   %efficiency for backscattering
    gp=Ap(:, 5);    %asymmetry parameter
    qratiop=Ap(:, 6); % backscattering / scattering
    nrp=lognormal(j, Rseasalt, sigma); % lognormal size distribution
                                % particles per m3
    vol_tot=vol_tot+(4*pi/3)*Rseasalt^3*nrp*dj;
  
    sigma_ep=pi*j^2*Qextp*nrp*dj;  % extinction coefficient value
    sigma_sp=pi*j^2*Qscap*nrp*dj;  % scattering coefficient value
    sigma_ap=pi*j^2*Qabsp*nrp*dj;  % absorption coefficient value
    sigma_gp=gp*nrp*dj;     % asymmetry parameter (integrated for the size distribution)
    
    ext_coefp=ext_coefp+sigma_ep;      % extinction coefficient integration
    abs_coefp=abs_coefp+sigma_ap;      % absorption coefficient integration
    sca_coefp=sca_coefp+sigma_sp;      % scattering coefficient integration
    asy_par1p=asy_par1p+gp*pi*j^2*Qscap*nrp*dj;        % asymmetry parameter integration
    asy_par2p=asy_par2p+pi*j^2*Qscap*nrp*dj;
   
   
   end 
   ssap=sca_coefp/ext_coefp; %single scattering albedo
   asy_parp=asy_par1p/asy_par2p;

   if unit==1   
     % We have to include a 1e-3 factor to convert from micr2/cm3 into km2/km3=km-1
     fprintf(fileseasalt, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp*1e-3, sca_coefp*1e-3, abs_coefp*1e-3, ssap, asy_parp); 
   elseif unit==0
     fprintf(fileseasalt, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp/(vol_tot*dens), sca_coefp/(vol_tot*dens), abs_coefp/(vol_tot*dens), ssap, asy_parp);
   end

   
  waitbar(k/27,h); 
  end
  close(h);
  fclose(fileseasalt);
  eval(['load out_pseasalt.txt']) ; 
  control=out_pseasalt(:,2);
 if isnan(control)==1
   errordlg('INVALID seasalt MODE ', num2str(seasalt),' PARAMETERS','ERROR');
   exit;
 else
   eval(['copyfile out_pseasalt.txt out_pseasalt', num2str(seasalt), '.txt f']);
   
   LRT2=out_pseasalt;
 end
 



sound(10)
  
 
